/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.CmdMain;
import arq.qparse;
import arq.query;
import com.hp.hpl.jena.sparql.util.Utils;
import sdb.sdbconfig;
import sdb.sdbdump;
import sdb.sdbinfo;
import sdb.sdbload;
import sdb.sdbmeta;
import sdb.sdbprint;
import sdb.sdbquery;
import sdb.sdbsql;
import sdb.sdbtruncate;

public class SDBCmd {
    private static String sdbFile = null;
    private static boolean exitOnError = true;

    public static void setSDBConfig(String f) {
        sdbFile = f;
    }

    public static void setExitOnError(boolean exitOn) {
        exitOnError = exitOn;
    }

    public static int qparse(String ... args) {
        return SDBCmd.exit((CmdMain)new qparse(args));
    }

    public static int sparql(String ... args) {
        return SDBCmd.exit((CmdMain)new query(args));
    }

    public static int sdbprint(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbprint(SDBCmd.args(args)));
    }

    public static int sdbconfig(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbconfig(SDBCmd.args(args)));
    }

    public static int sdbload(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbload(SDBCmd.args(args)));
    }

    public static int sdbdump(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbdump(SDBCmd.args(args)));
    }

    public static int sdbquery(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbquery(SDBCmd.args(args)));
    }

    public static int sdbtruncate(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbtruncate(SDBCmd.args(args)));
    }

    public static int sdbinfo(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbinfo(SDBCmd.args(args)));
    }

    public static int sdbmeta(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbmeta(SDBCmd.args(args)));
    }

    public static int sdbsql(String ... args) {
        return SDBCmd.exit((CmdMain)new sdbsql(SDBCmd.args(args)));
    }

    private static int exit(CmdMain cmd) {
        int code = cmd.mainRun(false, false);
        if (code != 0 && exitOnError) {
            System.err.println("Exit: command: " + Utils.className((Object)cmd));
            System.exit(code);
        }
        return code;
    }

    private static String[] args(String[] a) {
        if (sdbFile != null) {
            String[] a2 = new String[a.length + 1];
            a2[0] = "--sdb=" + sdbFile;
            System.arraycopy(a, 0, a2, 1, a.length);
            a = a2;
        }
        return a;
    }
}

