/**
 * 
 */
package rs.fon.is.jamendo.persistence;

import java.util.Date;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.util.FileManager;

public class DataModelManager {

	private static final String directory = "tdb";
	private Dataset dataset;

	private static DataModelManager INSTANCE;
	
	private DataModelManager() { 
		dataset = TDBFactory.createDataset(directory);
	}

	public static DataModelManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new DataModelManager();
		}
		return INSTANCE;
	}

	public Model getModel() {
		return dataset.getDefaultModel();
	}

	public void importData(String filename, String syntax) {
		System.out.println("Importing data - " + new Date());
		FileManager.get().readModel(dataset.getDefaultModel(), filename, syntax);
		System.out.println("Import finished - " + new Date());
	}
	
	public void closeDataModel() {
		dataset.close();
	}

}
