package rs.fon.is.jamendo.services;

import java.util.ArrayList;
import java.util.List;

import rs.fon.is.jamendo.persistence.DataModelManager;
import rs.fon.is.queries.QueryExecutor;
import rs.fon.is.util.Constants;

import com.hp.hpl.jena.rdf.model.Model;

public class MusicService {
	
	private QueryExecutor queryExecutor = new QueryExecutor();
	
	public Model describeAllMusicArtist() {
		String query = 
			"PREFIX mo: <"+Constants.MO_NS+"> " + 
			"DESCRIBE ?artist " +
			"WHERE { " +
				"?artist a mo:MusicArtist. " +
			"}";
		
		return queryExecutor
				.executeDescribeSparqlQuery(query,
						DataModelManager.getInstance().getModel());
	}

	public List<String> getAllMusicians() {
		String queryString = 
			"PREFIX rdf: <"+Constants.RDF_NS+"> " + 
			"PREFIX mo: <"+Constants.MO_NS+"> " + 
			"PREFIX foaf: <"+Constants.FOAF_NS+"> " + 
			"SELECT ?name " + 
			"WHERE  { " + 
				"?musician rdf:type mo:MusicArtist ;" +
					"foaf:name ?name ." + 
			"}";

		return queryExecutor
				.executeSelectQueryOverModel(queryString, "name",
						DataModelManager.getInstance().getModel());
	}
	
	public List<String> getAllPunkers() {
		String query = 
			"PREFIX mo: <"+Constants.MO_NS+"> " + 
			"PREFIX foaf: <"+Constants.FOAF_NS+"> " + 
			"PREFIX tags: <"+Constants.TAGS_NS+"> " +
			"SELECT DISTINCT ?name " +
			"WHERE { " +
				"?artist a mo:MusicArtist; " +
					"foaf:name ?name; " +
					"foaf:made ?alb. " +
				"?alb tags:taggedWithTag <http://dbtune.org/jamendo/tag/punk>. " +
			"}";

		List<String> result = queryExecutor
				.executeSelectQueryOverModel(query, "name",
						DataModelManager.getInstance().getModel());
		
		if (result != null && !result.isEmpty()) {
			return result;
		}
		
		return new ArrayList<String>();
	}
}
