/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.graph.GraphSDB;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionDesc;
import com.hp.hpl.jena.sdb.sql.SDBConnectionFactory;
import com.hp.hpl.jena.sdb.store.DatasetStore;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sdb.store.StoreFactory;
import com.hp.hpl.jena.update.GraphStore;
import java.sql.Connection;

public class SDBFactory {
    public static SDBConnection createConnection(String jdbcURL, String user, String password) {
        return SDBConnectionFactory.create(jdbcURL, user, password);
    }

    public static SDBConnection createConnection(SDBConnectionDesc desc) {
        return SDBConnectionFactory.create(desc);
    }

    public static SDBConnection createConnection(Connection conn) {
        return SDBConnectionFactory.create(conn);
    }

    public static SDBConnection createConnection(String configFile) {
        return SDBConnectionFactory.create(configFile);
    }

    public static Connection createSqlConnection(SDBConnectionDesc desc) {
        return SDBConnectionFactory.createSqlConnection(desc);
    }

    public static Connection createSqlConnection(String configFile) {
        return SDBConnectionFactory.createJDBC(configFile);
    }

    public static Connection createSqlConnection(Model model) {
        return SDBConnectionFactory.createJDBC(model);
    }

    public static Store connectStore(String configFile) {
        return StoreFactory.create(configFile);
    }

    public static Store connectStore(StoreDesc desc) {
        return StoreFactory.create(desc);
    }

    public static Store connectStore(SDBConnection sdbConnection, StoreDesc desc) {
        return StoreFactory.create(desc, sdbConnection);
    }

    public static Store connectStore(Connection sqlConnection, StoreDesc desc) {
        SDBConnection sdb = SDBConnectionFactory.create(sqlConnection);
        return StoreFactory.create(desc, sdb);
    }

    public static Dataset connectDataset(Store store) {
        return DatasetStore.create(store);
    }

    public static Dataset connectDataset(StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(desc));
    }

    public static Dataset connectDataset(SDBConnection sdbConnection, StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(sdbConnection, desc));
    }

    public static Dataset connectDataset(Connection jdbcConnection, StoreDesc desc) {
        return DatasetStore.create(SDBFactory.connectStore(jdbcConnection, desc));
    }

    public static Dataset connectDataset(String configFile) {
        return DatasetStore.create(SDBFactory.connectStore(configFile));
    }

    public static GraphStore connectGraphStore(Store store) {
        return new DatasetStoreGraph(store, SDB.getContext().copy());
    }

    public static GraphStore connectGraphStore(StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(desc));
    }

    public static GraphStore connectGraphStore(SDBConnection sdbConnection, StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(sdbConnection, desc));
    }

    public static GraphStore connectGraphStore(Connection jdbcConnection, StoreDesc desc) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(jdbcConnection, desc));
    }

    public static GraphStore connectGraphStore(String configFile) {
        return SDBFactory.connectGraphStore(SDBFactory.connectStore(configFile));
    }

    public static Graph connectDefaultGraph(String configFile) {
        return SDBFactory.connectDefaultGraph(StoreFactory.create(configFile));
    }

    public static Graph connectDefaultGraph(StoreDesc desc) {
        return SDBFactory.connectDefaultGraph(StoreFactory.create(desc));
    }

    public static Graph connectDefaultGraph(Store store) {
        return new GraphSDB(store);
    }

    public static Graph connectNamedGraph(String configFile, String iri) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(configFile), iri);
    }

    public static Graph connectNamedGraph(StoreDesc desc, String iri) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(desc), iri);
    }

    public static Graph connectNamedGraph(Store store, String iri) {
        return new GraphSDB(store, iri);
    }

    public static Graph connectNamedGraph(String configFile, Node node) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(configFile), node);
    }

    public static Graph connectNamedGraph(StoreDesc desc, Node node) {
        return SDBFactory.connectNamedGraph(StoreFactory.create(desc), node);
    }

    public static Graph connectNamedGraph(Store store, Node node) {
        return new GraphSDB(store, node);
    }

    public static Model connectDefaultModel(String configFile) {
        return SDBFactory.connectDefaultModel(StoreFactory.create(configFile));
    }

    public static Model connectDefaultModel(StoreDesc desc) {
        return SDBFactory.connectDefaultModel(StoreFactory.create(desc));
    }

    public static Model connectDefaultModel(Store store) {
        return SDBFactory.createModelSDB(store);
    }

    public static Model connectNamedModel(StoreDesc desc, String iri) {
        return SDBFactory.connectNamedModel(StoreFactory.create(desc), iri);
    }

    public static Model connectNamedModel(Store store, String iri) {
        return SDBFactory.createModelSDB(store, iri);
    }

    public static Model connectNamedModel(String configFile, String iri) {
        return SDBFactory.connectNamedModel(StoreFactory.create(configFile), iri);
    }

    public static Model connectNamedModel(StoreDesc desc, Resource resource) {
        return SDBFactory.connectNamedModel(StoreFactory.create(desc), resource);
    }

    public static Model connectNamedModel(Store store, Resource resource) {
        return SDBFactory.createModelSDB(store, resource);
    }

    public static Model connectNamedModel(String configFile, Resource resource) {
        return SDBFactory.connectNamedModel(StoreFactory.create(configFile), resource);
    }

    private static Model createModelSDB(Store store) {
        return ModelFactory.createModelForGraph((Graph)new GraphSDB(store));
    }

    private static Model createModelSDB(Store store, String iri) {
        return ModelFactory.createModelForGraph((Graph)new GraphSDB(store, iri));
    }

    private static Model createModelSDB(Store store, Resource resource) {
        return ModelFactory.createModelForGraph((Graph)new GraphSDB(store, resource.asNode()));
    }
}

