/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.graph.GraphSDB;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Closeable;

public class DatasetStoreGraph
extends DatasetGraphCaching
implements DatasetGraph,
Closeable,
GraphStore {
    private final Store store;
    private Lock lock = new LockMRSW();
    private final Context context;

    public DatasetStoreGraph(Store store, Context context) {
        this(store, null, context);
    }

    public DatasetStoreGraph(Store store, GraphSDB graph, Context context) {
        this.store = store;
        this.defaultGraph = graph;
        this.context = context;
    }

    public Store getStore() {
        return this.store;
    }

    public Iterator<Node> listGraphNodes() {
        return StoreUtils.storeGraphNames(this.store);
    }

    public void startRequest() {
    }

    public void finishRequest() {
    }

    public Dataset toDataset() {
        return DatasetFactory.create((DatasetGraph)this);
    }

    protected boolean _containsGraph(Node graphNode) {
        return StoreUtils.containsGraph(this.store, graphNode);
    }

    protected Graph _createDefaultGraph() {
        return new GraphSDB(this.store);
    }

    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphSDB(this.store, graphNode);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        DatasetGraphCaching.Helper.addToDftGraph((DatasetGraphCaching)this, (Node)s, (Node)p, (Node)o);
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        DatasetGraphCaching.Helper.addToNamedGraph((DatasetGraphCaching)this, (Node)g, (Node)s, (Node)p, (Node)o);
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        DatasetGraphCaching.Helper.deleteFromDftGraph((DatasetGraphCaching)this, (Node)s, (Node)p, (Node)o);
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        DatasetGraphCaching.Helper.deleteFromNamedGraph((DatasetGraphCaching)this, (Node)g, (Node)s, (Node)p, (Node)o);
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphCaching.Helper.findInDftGraph((DatasetGraphCaching)this, (Node)s, (Node)p, (Node)o);
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return DatasetGraphCaching.Helper.findInAnyNamedGraphs((DatasetGraphCaching)this, (Node)s, (Node)p, (Node)o);
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return DatasetGraphCaching.Helper.findInSpecificNamedGraph((DatasetGraphCaching)this, (Node)g, (Node)s, (Node)p, (Node)o);
    }

    protected void _close() {
        this.store.close();
    }
}

