package rs.fon.is.sparql;


import java.io.FileInputStream;
import java.io.FileNotFoundException;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class RDFGraph {
	
	private Model dataModel;
	
	private String dataSource = "data/ldodds-knows.rdf";
	private String baseURI = "http://www.ldodds.com#";
	
	private static RDFGraph instance;

	private RDFGraph() {
		
		dataModel = ModelFactory.createDefaultModel();
		
		try {
			FileInputStream in = new FileInputStream(dataSource);
			dataModel.read(in, baseURI);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
			
	}
	
	public Model getDataModel() {
		return dataModel;
	}

	public static RDFGraph getInstance() {
		if ( instance == null )
			instance = new RDFGraph();
		return instance;
	}
	
}
