package rs.fon.is.sparql;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Iterator;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;

public class SPARQLUtil {
	
	public static final String DBPEDIA_SPARQL_ENDPOINT = "http://dbpedia.org/sparql";
	
	public static ResultSet executeSelectQueryOverSparqlEndpoint(String query, String sparqlEndpoint) {
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		return qe.execSelect();
	}
	
	public static ResultSet executeSelectQueryOverModel(String query, Model model) {
		QueryExecution qe = QueryExecutionFactory.create(query, model);
		return qe.execSelect();
	}
	
	public static boolean executeAskSparqlQuery(String query, String sparqlEndpoint) {
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		boolean result = qe.execAsk();
		
		qe.close();
		
		return result;
	}
	
	public static Model executeDescribeSparqlQuery(String query, String sparqlEndpoint) {
		// Execute the query and obtain results
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		Model resultModel = qe.execDescribe();
		
		// Important - free up resources used running the query
		qe.close();
		
		return resultModel;
	}
	
	public static Model executeConstructSparqlQuery(String query, String sparqlEndpoint) {
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		Model resultModel = qe.execConstruct();
		qe.close();
		return resultModel;
	}
	
	
	public static void printSPARQLSelectResults(ResultSet resultSet, PrintStream out) {
		
		int cnt = 0;
		while (resultSet.hasNext()) {
			QuerySolution result = (QuerySolution) resultSet.next();
			cnt++;
			
			Iterator<String> variables = result.varNames();

			while (variables.hasNext()) {
				String var = (String) variables.next();

				RDFNode value = result.get(var);

				if (value.isLiteral())
					out.println(var + ": " + value.asLiteral().getLexicalForm());
				else if ( value.isURIResource() )
						out.println(var + ": " + value.asResource().getURI());
				else out.println(var + ": BNode: " + value.asNode().getBlankNodeLabel());

			}
			out.println("----------------------------");
		}
		System.out.println("\nTotal number of results: " + cnt);
	}
	
	public static int getResultsCount(ResultSet resultSet) {
		int cnt = 0;
		while (resultSet.hasNext()) {
			resultSet.next();
			cnt++;
		}
		return cnt;
	}
	
	public static String readTextFromFile(String fileName, String encoding) throws IOException {
		
		StringBuilder sb = new StringBuilder();
		
		Reader reader = new InputStreamReader(new FileInputStream(fileName), encoding);
		BufferedReader in = new BufferedReader(reader);
		
		String line = null;
		while ( (line = in.readLine()) != null ) {
			sb.append( line );
			sb.append("\n");
		}
		in.close();
		
		return sb.toString();
		
	}

}
