package com.sample;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.goodoldai.jeff.wizard.JEFFWizard;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

	public static final void main(String[] args) {
		try {
			// load up the knowledge base
			KnowledgeBase kbase = readKnowledgeBase();
			StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
			KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger(ksession, "test");
			// go !
			
			//Kreiranje objekta JEFFWizard klase i inicijalizacija objasnjenja
			JEFFWizard wizard = new JEFFWizard(null, "Dijagnoza kvara na automobilu");
			
			wizard.createExplanation();
			
			//Unos JEFFWizard objekta u radnu memoriju kao globalne promenljive
			ksession.setGlobal("ef", wizard);		
            
			//Kreiranje cinjenica
            Automobil a = new Automobil();
            
            a.setVerglanje("Ne");
            a.setRadeFarovi("Ne");
            a.setRadeLampice("Ne");
            
            //Unos cinjenica u radnu memoriju
            ksession.insert(a);
            
            //Pokretanje ES
			ksession.fireAllRules();
			
			//Formiranje objasnjenja tj. resenja kao PDF fajla
			wizard.generatePDFReport("report.pdf", false);
            
			logger.close();
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	private static KnowledgeBase readKnowledgeBase() throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource("DijagnozaAutoKvarova.drl"), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if (errors.size() > 0) {
			for (KnowledgeBuilderError error: errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}

}