/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.gui.Messages;

public class JTableHelper {
    private JTable jtable;

    public JTableHelper(JTable jtable) {
        this.jtable = jtable;
    }

    public JTable getJTable() {
        return this.jtable;
    }

    public int calcColumnWidth(int col) {
        return JTableHelper.calcColumnWidth(this.getJTable(), col);
    }

    public static int calcColumnWidth(JTable table, int col) {
        int width = JTableHelper.calcHeaderWidth(table, col);
        if (width == -1) {
            return width;
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int rowCount = data.getRowCount();
        TableColumn column = columns.getColumn(col);
        try {
            for (int row = rowCount - 1; row >= 0; --row) {
                Component c = table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                width = Math.max(width, c.getPreferredSize().width + 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return width;
    }

    public int calcHeaderWidth(int col) {
        return JTableHelper.calcHeaderWidth(this.getJTable(), col);
    }

    public static int calcHeaderWidth(JTable table, int col) {
        if (table == null) {
            return -1;
        }
        if (col < 0 || col > table.getColumnCount()) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder.append(Messages.getString("JTableHelper_CalcHeaderWidth_Text")).append(col).toString());
            return -1;
        }
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        TableColumn column = columns.getColumn(col);
        int width = -1;
        TableCellRenderer h = column.getHeaderRenderer();
        if (h == null) {
            h = defaultHeaderRenderer;
        }
        if (h != null) {
            Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, col);
            width = c.getPreferredSize().width + 5;
        }
        return width;
    }

    public void setOptimalColumnWidth(int col) {
        JTableHelper.setOptimalColumnWidth(this.getJTable(), col);
    }

    public static void setOptimalColumnWidth(JTable jtable, int col) {
        int width;
        if (col >= 0 && col < jtable.getColumnModel().getColumnCount() && (width = JTableHelper.calcColumnWidth(jtable, col)) >= 0) {
            JTableHeader header = jtable.getTableHeader();
            TableColumn column = jtable.getColumnModel().getColumn(col);
            column.setPreferredWidth(width);
            jtable.sizeColumnsToFit(-1);
            header.repaint();
        }
    }

    public void setOptimalColumnWidth() {
        JTableHelper.setOptimalColumnWidth(this.getJTable());
    }

    public static void setOptimalColumnWidth(JTable jtable) {
        for (int i = 0; i < jtable.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalColumnWidth(jtable, i);
        }
    }

    public void setOptimalHeaderWidth(int col) {
        JTableHelper.setOptimalHeaderWidth(this.getJTable(), col);
    }

    public static void setOptimalHeaderWidth(JTable jtable, int col) {
        int width;
        if (col >= 0 && col < jtable.getColumnModel().getColumnCount() && (width = JTableHelper.calcHeaderWidth(jtable, col)) >= 0) {
            JTableHeader header = jtable.getTableHeader();
            TableColumn column = jtable.getColumnModel().getColumn(col);
            column.setPreferredWidth(width);
            jtable.sizeColumnsToFit(-1);
            header.repaint();
        }
    }

    public void setOptimalHeaderWidth() {
        JTableHelper.setOptimalHeaderWidth(this.getJTable());
    }

    public static void setOptimalHeaderWidth(JTable jtable) {
        for (int i = 0; i < jtable.getColumnModel().getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(jtable, i);
        }
    }

    public void scrollToVisible(int row, int col) {
        JTableHelper.scrollToVisible(this.getJTable(), row, col);
    }

    public static void scrollToVisible(JTable table, int row, int col) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(row, col, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }
}

