/*
 * Authors: 
 * Uros Krcadinac - uros@krcadinac.com
 * Nikola Milikic - nikola.milikic@gmail.com
 * 
 * GOOD OLD AI Research Lab - http://goodoldai.org
 * Intelligent Systems (FON, University of Belgrade) - http://is.fon.rs/
 * 
 * November, 2013.
 * 
 * This code is partially based on these very useful resources for text mining in Weka:
 * http://jmgomezhidalgo.blogspot.com.es/2013/04/a-simple-text-classifier-in-java-with.html
 * http://jmgomezhidalgo.blogspot.com.es/2013/05/language-identification-as-text.html
 * http://jmgomezhidalgo.blogspot.com.es/2013/06/baseline-sentiment-analysis-with-weka.html
 * 
 * (Note: if you plane to use the code from these sites, please use Weka 3.7. 
 * Our code is using Weka 3.6. There are some differences in terms of API.) 
 * 
 */

package rs.fon.is.weka.textmining.sa;

public class StartSentimentAnalysis {

	public static void main (String[] args) {
		
		/*
		 * Examples of 2 book reviews, a positive and a negative one.
		 */
		String randomReview1 = "The Cat's Cradle by Vonnegut is an amazing book, the best one I read in months. So good I reread it.";
		String randomReview2 = "Most books by Dobrica Cosic were poorly written and completely terrible in terms of ethics.";

		String classifierPath = "classifiers/sentimentAnalysisClassifier.dat";
		String arffFileName = "data/sa/SFU_Review_Corpus.arff";

		try {
			/*
			 * Creating a new instance of the SentimentAnalysis class.
			 */
			SentimentAnalysis iden = new SentimentAnalysis(classifierPath, arffFileName);

			/*
			 * Classifying these two reviews.
			 */
			System.out.println("Classifying sentence: \"" + randomReview1 + "\"");
			iden.checkTextInstace(randomReview1);
			
			System.out.println("Classifying sentence: \"" + randomReview2 + "\"");
			iden.checkTextInstace(randomReview2);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
