package com.sample;

import java.awt.Desktop;

import org.goodoldai.jeff.wizard.JEFFWizard;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

    public static final void main(String[] args) {
        try {
            // load up the knowledge base
	        KieServices ks = KieServices.Factory.get();
    	    KieContainer kContainer = ks.getKieClasspathContainer();
        	KieSession kSession = kContainer.newKieSession("ksession-rules");

        	//Kreiranje instance mehanizma za objasnjavanje
            JEFFWizard ef = new JEFFWizard();
            ef.setInternationalization(false);
            //Postavljanje naslova objasnjenja i kreiranje praznog objasnjenja
            ef.setTitle("Dijagnoza kvara u automobilu");
            ef.createExplanation();
            
            //Kreiranje cinjenica
            Automobil a = new Automobil();
            
            a.setVerglanje("Da");
            a.setMirisBenzina("Ne");
            a.setPrazanRezervoar("Da");
            
            //Unosenje cinjenica u radnu memoriju
            kSession.insert( a );
            
            //Unosenje instance mehanizma za objasnjavanje u radnu memoriju kao globalne promenljive
            kSession.setGlobal("ef", ef);
            
            //Pokretanje ES
            kSession.fireAllRules();
            
            //Ispisivanje rezultata
            System.out.println(a);
            
          //Pravljenje PDF fajla koji sadrzi objasnjenje i njegovo prikazivanje
            ef.generatePDFReport("Objasnjenje.pdf",false);
            if (Desktop.isDesktopSupported())
            	java.awt.Desktop.getDesktop().browse(java.net.URI.create((new java.io.File("Objasnjenje.pdf").toURI().toString())));
            
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

}
