package com.sample;

import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

    public static final void main(String[] args) {
        try {
            // load up the knowledge base
	        KieServices ks = KieServices.Factory.get();
    	    KieContainer kContainer = ks.getKieClasspathContainer();
        	KieSession kSession = kContainer.newKieSession("ksession-rules");

        	//Kreiranje cinjenica
            Golfer g1 = new Golfer();
            g1.setIme("Fred");
            
            Golfer g2 = new Golfer();
            g2.setIme("Bob");
            
            Golfer g3 = new Golfer();
            g3.setIme("Tom");
            
            Golfer g4 = new Golfer();
            g4.setIme("Joe");
            
            //Ispisivanje cinjenica pre zakljucivanja
            System.out.println("Pocetno stanje cinjenica");
            System.out.println(g1);
            System.out.println(g2);
            System.out.println(g3);
            System.out.println(g4);

            //Unosenje cinjenica u radnu memoriju
            kSession.insert( g1 );
            kSession.insert( g2 );
            kSession.insert( g3 );
            kSession.insert( g4 );
            
            //Pokretanje ES
            kSession.fireAllRules();
            
            //Ispisivanje rezultata
            System.out.println("Cinjenice posle zakljucivanja");
            System.out.println(g1);
            System.out.println(g2);
            System.out.println(g3);
            System.out.println(g4);
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

}
