package art.music;
import java.util.GregorianCalendar;

import art.WorkOfArt;

import java.text.SimpleDateFormat;

public class Song implements WorkOfArt {
    
    private static String definition;
    
    private String title;
    private String author;
    private int year;
    private GregorianCalendar releaseDate;
    
    static {
        definition = "A nice thing :)";
    }
    
    public Song(String title, String author, int year, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.releaseDate = releaseDate;
    }
    
    public Song(String title, String author, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.releaseDate = releaseDate;
        this.year = this.releaseDate.YEAR;
    }
    
    public Song(String title, String author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
    public Song() {
    }
    
    public void display() {
        System.out.println("Song " + '\"' + this.title + '\"' + '\n' +
                           '\t' + "author: " + this.author + '\n' +
                           '\t' + "year: " + this.year);
    }
    
    public static void displayDefinition() {
        System.out.println(definition);
    }
    
    @Override
    public void describe() {
        display();
        System.out.println('\t' + getDefinition());
    }
    
    @Override
    public void showDate() {
        System.out.println("Released: " + getDate());
    }

    public String toString() {
        return this.title + " (" + getDate() + ')';
    }
    
    private String getDate() {
        return (new SimpleDateFormat("MMM dd, yyyy")).format(releaseDate.getTime());
    }
    
    public void setDefinition(String definition) {
        this.definition = definition;
    }
    
    public String getDefinition() {
        return this.definition;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setReleaseDate(GregorianCalendar releaseDate) {
        this.releaseDate = releaseDate;
    }
    
    public GregorianCalendar getReleaseDate() {
        return this.releaseDate;
    }

}
