/*
 * Created on Dec 4, 2016
 *
 */
package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.ImageIcon;
import java.awt.Font;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class HelloWorld {

    private JFrame frame;
    private JPanel panel;
    private JButton btnStart;
    private JLabel lblNewLabel;
    private JLabel lblExpectingToFly;

    /**
     * Launch the application.
     */
    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                try {
                    HelloWorld window = new HelloWorld();
                    window.frame.setVisible(true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /**
     * Create the application.
     */
    public HelloWorld() {
        initialize();
    }

    /**
     * Initialize the contents of the frame.
     */
    private void initialize() {
        frame = new JFrame();
        frame.setBounds(100, 100, 696, 517);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.getContentPane().add(getPanel(), BorderLayout.NORTH);
        frame.getContentPane().add(getLblNewLabel(), BorderLayout.CENTER);
    }

    private JPanel getPanel() {
        if (panel == null) {
        	panel = new JPanel();
        	panel.add(getBtnStart());
        	panel.add(getLblExpectingToFly());
        }
        return panel;
    }
    private JButton getBtnStart() {
        if (btnStart == null) {
        	btnStart = new JButton("Start");
        	btnStart.addActionListener(new ActionListener() {
        	    public void actionPerformed(ActionEvent arg0) {
                    lblNewLabel.setVisible(true);
                    lblExpectingToFly.setVisible(true);
                    btnStart.setVisible(false);
        	    }
        	});
        }
        return btnStart;
    }
    private JLabel getLblNewLabel() {
        if (lblNewLabel == null) {
        	lblNewLabel = new JLabel((String) null);
        	lblNewLabel.setVisible(false);
        	lblNewLabel.setIcon(new ImageIcon("D:\\Vladan\\Courses\\P2\\My Java Programs\\Eclipse Workspace\\Expecting to Fly\\Neil-Young.jpg"));
        	lblNewLabel.setHorizontalAlignment(SwingConstants.CENTER);
        }
        return lblNewLabel;
    }
    private JLabel getLblExpectingToFly() {
        if (lblExpectingToFly == null) {
        	lblExpectingToFly = new JLabel("Expecting to Fly");
        	lblExpectingToFly.setVisible(false);
        	lblExpectingToFly.setForeground(new Color(0, 191, 255));
        	lblExpectingToFly.setFont(new Font("Tahoma", Font.BOLD, 16));
        }
        return lblExpectingToFly;
    }
}
