package music;

import java.util.ArrayList;

public class Band {
	
	private String name;
	private ArrayList<Musician> members;
	
	public Band(String name, ArrayList<Musician> members) {
		super();
		this.name = name;
		this.members = members;
	}
	
	public Band() {
		members = new ArrayList<Musician>();
	}
	
	public void addMember(Musician musician) {
		members.add(musician);
	}
	
	public boolean removeMember(Musician member) {
		return members.remove(member);
	}
	
	@Override
	public String toString() {
		StringBuffer band = new StringBuffer();
		band.append("Band: " + this.name + '\n');
		for (int i = 0; i < members.size(); i++) {
			band.append('\t' + members.get(i).toString() + '\n');
		}
		return band.toString();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public ArrayList<Musician> getMembers() {
		return members;
	}

	public void setMembers(ArrayList<Musician> members) {
		this.members = members;
	}
	
	

}
