package test;
import java.util.Scanner;

import javax.management.remote.SubjectDelegationPermission;
import javax.swing.text.Utilities;

import art.Artwork;
import art.poetry.Poem;
import music.AdditionalMusician;
import music.Album;
import music.Band;
import music.EmptyPlaylistException;
import music.Guitarist;
import music.LeadGuitarist;
import music.Musician;
import music.Playlist;
import music.Song;
import music.StudioCollaborator;
import music.TourMusician;
import util.Utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.GregorianCalendar;

public class Test {
    
    public static final Scanner IN = new Scanner(System.in);
    
    public void tryOutJava() {
        Song.define();
        Song expectingToFly = new Song("Expecting to Fly", "Buffalo Springfield", 1966);
//         expectingToFly.definition = "Wow!";
//        System.out.println(expectingToFly.definition);
        System.out.println();
        Song californiaDreaming = new Song("California Dreamin'", "Mamas and Papas", 1966);
        System.out.println(californiaDreaming.definition);
        System.out.println();
        System.out.println("From Song.definition:");
        System.out.println(Song.definition);
        
        System.out.println();
        
        System.out.println("Expecting to Fly");
        int a = 3;
        // khtdjtrd
        double d = 23.45;
//         char c = 'r';
        char c = '\"';
        
        if (a == 1) {
            System.out.println("a = 1");
        } else {
            System.out.println("a != 1");
        }
        
        for (int i = 0; i < 3; i++) {
//             System.out.println('a' + "Expecting to Fly");
            System.out.println('\"' + "Expecting to Fly" + '\"' + " is a nice song.");
        }
    }
    
    public void testSongs() {
//         Song expectingToFly = new Song();
// //         expectingToFly.title = "Expecting to Fly";
// //         expectingToFly.author = "Buffalo Springfield";
// //         expectingToFly.year = 1966;
// //         expectingToFly.display();
//         expectingToFly.setTitle("Expecting to Fly");
//         expectingToFly.setAuthor("Buffalo Springfield");
//         expectingToFly.setYear(1966);
        
        Song expectingToFly = new Song("Expecting to Fly", "Buffalo Springfield", 1966);
//         System.out.println(expectingToFly.getTitle());
        expectingToFly.display();
    }
    
    public void testFinal() {
        final int a = 1;
//         a = 2;
    }
    
    public void testScanner() {
        Song californiaDreaming = new Song();
        System.out.print("Read a song title: ");
        String title = IN.nextLine();
        californiaDreaming.setTitle(title);
        System.out.println(californiaDreaming.getTitle());
        
        System.out.print("Read the song's year: ");
        int year = IN.nextInt();
        californiaDreaming.setYear(year);
        System.out.println(californiaDreaming.getYear());
    }
    
    public void testLoops() {
        int[] a = new int[3];
//         for (int i = 0; i < a.length; i++) {
//             a[i] = i + 1;
//             System.out.println(a[i]);
//         }
        int i = 0;
        while (i < a.length) {
            a[i] = i + 1;
            if (i == 1) {
                i++;
//                 continue;
                break;
            }
            System.out.println(a[i]);
            i++;
        }
        
        double[] d = {1.9, 2.45, -12.34};
    }
    
    public void testSwitch() {
        System.out.print("Read n: ");
        int n = IN.nextInt();
        switch (n) {
            case 1: System.out.println("One"); break;
            case -3: System.out.println("Minus three"); break;
            default: System.out.println("Default: something else");
        }
    }
    
    public void testAlbum() {
        Song rainyDayWomen = new Song("Rainy Day Women", "Bob Dylan", 1966);
        Song visionsOfJohanna = new Song("Visions of Johanna", "Bob Dylan", 1966);
        Song justLikeAWoman = new Song("Just Like a Woman", "Bob Dylan", 1966);
        
        Song[] songs = {rainyDayWomen, visionsOfJohanna, justLikeAWoman};
        
//         Album blondeOnBlonde = new Album("Blonde on Blonde", "Bob Dylan", 1966, songs);
        Album blondeOnBlonde = new Album("Blonde on Blonde", "Bob Dylan", 1966, 3);
        
        blondeOnBlonde.setSongs(songs);
        
        Song[] blondeOnBlondeSongs = blondeOnBlonde.getSongs();
        for (int i = 0; i < blondeOnBlondeSongs.length; i++) {
            blondeOnBlondeSongs[i].display();
        }
    }
    
    public void testNumberFormatting() {
        NumberFormat nf = NumberFormat.getInstance();
        System.out.println(12.0/34.8765);
        nf.setMaximumFractionDigits(2);
        System.out.println(nf.format(12.0/34.8765));
        System.out.println(nf.format(11.0/34.8555));
        System.out.println(12.0/34.8765);
        nf.setMaximumFractionDigits(3);
        System.out.println(nf.format(12.0/34.8765));
    }
    
    public void testAPI() {
        Song rainyDayWomen = new Song("Rainy Day Women", "Bob Dylan", 1966);
        System.out.println(rainyDayWomen);
        System.out.println();
        
//         String title = "Rainy Day Women";
        String title = new String("Rainy Day Women");
        char[] chars = {'D', 'a', 'y'};
        String day = new String(chars);
        System.out.println(day);
        System.out.println();
        
        if (title.endsWith("Women")) {
            System.out.println("Yes, it ends with Women.");
        } else {
            System.out.println("No, it does not...");
        }
        
//         String title2 = "Rainy".concat(day);
        String title2 = "Rainy".concat(" ").concat(day);
        System.out.println(title2);
        System.out.println();
        
        String[] words = title.split(" ");
        System.out.println(title);
        for (int i = 0; i < words.length; i++) {
            System.out.println(words[i]);
        }
        System.out.println();
        
        StringBuffer title3 = new StringBuffer("Woman");
        System.out.println(title3);
        title3.append(" of");
        System.out.println(title3);
        System.out.println();
        title3.append(' ').append("my ").append("dreamss");
        System.out.println(title3);
//         int currentLength = title3.length();
//         title3.delete(currentLength - 1, currentLength);
        title3.delete(title3.length() - 1, title3.length());
        System.out.println(title3);
        System.out.println(title3);
        System.out.println();
        
        Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
        Song wildThing = new Song("Wild Thing", "The Troggs", new GregorianCalendar(1966, GregorianCalendar.APRIL, 22));
        Song outOfTime = new Song("Out of Time", "The Rolling Stones", new GregorianCalendar(1966, GregorianCalendar.APRIL, 15));
        
        if (forWhatItsWorth.getReleaseDate().before(wildThing.getReleaseDate())) {
            System.out.println(forWhatItsWorth.getTitle() + " was released before " + wildThing.getTitle());
        } else {
            System.out.println(forWhatItsWorth.getTitle() + " was released after " + wildThing.getTitle());
        }
        System.out.println();
        
        System.out.println(forWhatItsWorth);
        System.out.println(wildThing);
        System.out.println(outOfTime);
    }
    
    public void testLists() {
    	Musician neilYoung = new Musician("Neil Young", "guitars, keyboards, harmonica, vocals");
    	Musician stephenStills = new Musician("Stephen Stills", "guitars, vocals");
    	Musician ritchieFuray = new Musician("Ritchie Furay", "guitars, vocals");
    	Musician brucePalmer = new Musician("Bruce Palmer", "bass");
    	Musician deweyMartin = new Musician("Dewey Martin", "drums");

//    	System.out.println(neilYoung);
    	
    	Band buffaloSpringfield = new Band();
    	buffaloSpringfield.setName("Buffalo Springfield");
    	buffaloSpringfield.addMember(neilYoung);
    	buffaloSpringfield.addMember(stephenStills);
    	System.out.println(buffaloSpringfield);
    	System.out.println();
    	
    	buffaloSpringfield.addMember(brucePalmer);
    	buffaloSpringfield.addMember(deweyMartin);
    	buffaloSpringfield.addMember(ritchieFuray);
    	System.out.println(buffaloSpringfield);
    	System.out.println();
    	
    	buffaloSpringfield.removeMember(brucePalmer);
    	System.out.println(buffaloSpringfield);
    	System.out.println();
    	
    }
    
    public void testInheritance() {
    	Musician neilYoung = new Musician("Neil Young", "guitars, keyboards, harmonica, vocals");
    	Guitarist stephenStills = new Guitarist("Stephen Stills", "guitar, vocals", "Martin");
    	LeadGuitarist keithRichards = new LeadGuitarist("Keith Richards", "guitar", "Fender, Gibson", "riffs");
    	
    	System.out.println(neilYoung);
    	System.out.println(stephenStills);
    	System.out.println(keithRichards);
    	System.out.println();
    	
    	neilYoung.printDetails();
    	stephenStills.printDetails();
    	keithRichards.printDetails();
    	System.out.println();
    	
    	Musician[] musicians = {neilYoung, stephenStills, keithRichards};
    	System.out.println(neilYoung.getName());
//    	System.out.println(neilYoung.getFavoriteGuitar());
    	System.out.println(stephenStills.getFavoriteGuitar());
//    	System.out.println(musicians[1].getFavoriteGuitar());
    	System.out.println();
    	
    	for (int i = 0; i < musicians.length; i++) {
			musicians[i].printDetails();
		}
    	System.out.println();
    	
//    	AdditionalMusician gregReeves = new AdditionalMusician();
//    	StudioCollaborator gregReeves = new StudioCollaborator("Greg Reeves", "bass", "studio sessions", 1967, 1968);
    	AdditionalMusician gregReeves = new StudioCollaborator("Greg Reeves", "bass", "studio sessions", 1967, 1968);
//    	TourMusician rickRosas = new TourMusician("Rick Rosas", "bass", "tours", "Harvest Moon"); 
    	AdditionalMusician rickRosas = new TourMusician("Rick Rosas", "bass", "tours", "Harvest Moon"); 
//    	gregReeves.printDetails();
    	gregReeves.showDetails();
    	rickRosas.showDetails();
    	System.out.println();
    	
    	Musician nY = new Musician("Neil Young", "guitars, keyboards, harmonica, vocals");
    	if (nY.equals(neilYoung)) {
    		System.out.println("Neil Young!!!");
    	} else {
    		System.out.println("Not Neil Young... :(");
    	}
    }
    
    public void testInterfaces() {
//        Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
        Artwork forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
        forWhatItsWorth.describe();
//        forWhatItsWorth.setTitle("klud");
        Artwork aDreamWithinADream = new Poem("A Dream Within a Dream", "Edgar Allan Poe", 1849);
        
        forWhatItsWorth.describe();
        forWhatItsWorth.showDate();
        aDreamWithinADream.describe();
        aDreamWithinADream.showDate();
    }
    
    public void testExceptions() {
//    	int[] a = {1, 2, 3};
//    	try {
//			for (int i = 0; i < 4; i++) {
//				System.out.println(a[i]);
//			}
//		} catch (ArrayIndexOutOfBoundsException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}
    	
//    	String s = null;
//    	System.out.println(s.length());
    	
    	Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
    	Song rainyDayWomen = new Song("Rainy Day Women", "Bob Dylan", 1966);
    	
    	Playlist playlist = new Playlist();
//    	playlist.addSong(forWhatItsWorth);
//    	playlist.addSong(rainyDayWomen);
    	try {
			playlist.playAll();
		} catch (EmptyPlaylistException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
//			System.err.println("Something");
		}
    }
    
    public void testIO() {
    	Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", 1966, new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
    	File f = new File("text.txt");
    	try {
//			PrintWriter out = new PrintWriter(new FileWriter(f));
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
			out.println(forWhatItsWorth.getTitle());
			out.println(forWhatItsWorth.getAuthor());
			out.println(forWhatItsWorth.getYear());
			out.flush();
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	System.out.println("Done.");
    	
    	Song s = new Song();
    	try {
			BufferedReader in = new BufferedReader(new FileReader(f));
//			BufferedReader in1 = new BufferedReader(new InputStreamReader(System.in));
			s.setTitle(in.readLine());
			s.setAuthor(in.readLine());
			s.setYear(Integer.parseInt(in.readLine()));
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated cath block
			e.printStackTrace();
		}
    	s.display();
    }
    
    public void testDataIO() {
    	Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", 1966, new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
    	File f = new File("song.data");
    	try {
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
			out.writeUTF(forWhatItsWorth.getTitle());
			out.writeUTF(forWhatItsWorth.getAuthor());
			out.writeInt(forWhatItsWorth.getYear());
			out.flush();
			out.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	System.out.println("Done.");
    	
    	Song s = new Song();
    	try {
			DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
			s.setTitle(in.readUTF());
			s.setAuthor(in.readUTF());
			s.setYear(in.readInt());
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	s.display();
    }
    
    public void testSerialization() {
    	Song forWhatItsWorth = new Song("For What It's Worth", "Buffalo Springfield", 1966, new GregorianCalendar(1967, GregorianCalendar.JANUARY, 9));
    	forWhatItsWorth.serialize("song.serial");
    	System.out.println("Done.");
    }
    
    public void testDeserialization() {
    	Song forWhatItsWorth = Song.deserialize("song.serial");
    	forWhatItsWorth.display();
    }
    
    public void testPaths() {
    	System.out.println(Utility.getProjectDir());
    	System.out.println(Utility.mkProjectSubdir("dir1"));
    	System.out.println(Utility.mkProjectSubdir("dir1\\dir2\\"));
    	File f = new File(Utility.mkProjectSubdir("dir1\\dir2\\"), "f.txt");
    	System.out.println(f.getAbsolutePath());
    }
}
