package art.music;
import java.util.ArrayList;

public class Band {
    
    private String name;
    private ArrayList<Musician> members;
    
    public Band(String name, ArrayList<Musician> members) {
        this.name = name;
        this.members = members;
    }
    
    public Band(String name) {
        this.name = name;
        this.members = new ArrayList<Musician>();
    }
    
    public Band() {
    }
    
    public String toString() {
        StringBuffer band = new StringBuffer(this.name + ':' + '\n');
        for (int i = 0; i < members.size(); i++) {
            band.append('\t' + members.get(i).getName() + ": " + members.get(i).getInstrument() + '\n');
        }
        return band.toString();
    }
    
    public void addMember(Musician member) {
        members.add(member);
    }
    
    public void removeMember(Musician member) {
        members.remove(member);
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public String getName() {
        return this.name;
    }
    
    public void setMembers(ArrayList<Musician> members) {
        this.members = members;
    }
    
    public ArrayList<Musician> getMembers() {
        return this.members;
    }
    
}
