/*
 * Created on Nov 20, 2016
 *
 */
package art.music;

import java.util.Iterator;
import java.util.LinkedList;

public class Playlist {
    
    private LinkedList<Song> songs;

    public Playlist(LinkedList<Song> songs) {
        super();
        this.songs = songs;
    }

    public Playlist() {
        this.songs = new LinkedList<Song>();
    }
    
    public void addSong(Song song) {
        songs.add(song);
    }
    
    public void removeSong(Song song) {
        songs.remove(song);
    }
    
    public void removeSong() {
        songs.remove();
    }
    
    public void playAll() throws EmptyPlaylistException {
        if (songs.size() != 0) {
            for (Song song : songs) {
                song.display();
            }
        } else {
            throw new EmptyPlaylistException();
        }
    }

    public LinkedList<Song> getSongs() {
        return songs;
    }

    public void setSongs(LinkedList<Song> songs) {
        this.songs = songs;
    }
    

}
