package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.SwingConstants;

import music.Song;

import javax.swing.JLabel;
import java.awt.Font;
import java.awt.Color;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JTextField;
import javax.swing.JComboBox;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.awt.event.ItemEvent;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class MainAppWindow {

	private JFrame frmExpectingToFly;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centerPanel;
	private JButton btnStartButton;
	private JLabel lbl1966;
	private JLabel lblSong;
	private JComboBox comboBoxSong;
	private JSplitPane splitPaneSong;
	private JScrollPane scrollPaneSong;
	private JLabel lblIllustration;
	private JScrollPane scrollPaneLyrics;
	private JTextArea textAreaLyrics;
	private JLabel lblAuthor;
	private JTextField textFieldAuthor;
	private JButton btnSave;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnIllustration;
	private JRadioButton rdbtnAll;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JLabel lblView;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNew;
	private JMenuItem mntmOpen;
	private JMenuItem mntmSave;
	private JMenuItem mntmExit;
	private JSeparator separator;

	private Song song;
	private NewDialog newDialog;
	private LinkedList<Song> songs = new LinkedList<Song>();
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmExpectingToFly.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmExpectingToFly = new JFrame();
		frmExpectingToFly.setTitle("Expecting to Fly");
		frmExpectingToFly.setBounds(100, 100, 687, 479);
		frmExpectingToFly.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmExpectingToFly.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmExpectingToFly.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmExpectingToFly.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmExpectingToFly.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmExpectingToFly.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
		frmExpectingToFly.setJMenuBar(getMenuBar());
		deserializeSongs();
        for (int i = 0; i < songs.size(); i++) {
            comboBoxSong.addItem(songs.get(i).getTitle());
        }
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
			northPanel.add(getBtnStartButton());
			northPanel.add(getLbl1966());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setVisible(false);
			westPanel.setPreferredSize(new Dimension(150, 10));
			westPanel.setLayout(new MigLayout("", "[24px,grow]", "[14px][]"));
			westPanel.add(getLblSong(), "cell 0 0,alignx left,aligny top");
			westPanel.add(getComboBoxSong(), "cell 0 1,growx");
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setVisible(false);
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][grow][]"));
			eastPanel.add(getLblAuthor(), "cell 0 0");
			eastPanel.add(getTextFieldAuthor(), "cell 0 1,growx");
			eastPanel.add(getBtnSave(), "cell 0 3,alignx right");
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setVisible(false);
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblView(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnIllustration(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setVisible(false);
			centerPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centerPanel.add(getSplitPaneSong(), "cell 0 0,grow");
		}
		return centerPanel;
	}
	private JButton getBtnStartButton() {
		if (btnStartButton == null) {
			btnStartButton = new JButton("Start");
			btnStartButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
//					System.out.println("1966");
					getLbl1966().setVisible(true);
					getWestPanel().setVisible(true);
					getEastPanel().setVisible(true);
					getCenterPanel().setVisible(true);
					getSouthPanel().setVisible(true);
					btnStartButton.setVisible(false);
		            rdbtnIllustration.setSelected(true);
				}
			});
		}
		return btnStartButton;
	}
	private JLabel getLbl1966() {
		if (lbl1966 == null) {
			lbl1966 = new JLabel("1966");
			lbl1966.setVisible(false);
			lbl1966.setForeground(new Color(0, 153, 0));
			lbl1966.setFont(new Font("Tahoma", Font.BOLD, 16));
		}
		return lbl1966;
	}
	private JLabel getLblSong() {
		if (lblSong == null) {
			lblSong = new JLabel("Song");
		}
		return lblSong;
	}
	private JComboBox getComboBoxSong() {
		if (comboBoxSong == null) {
			comboBoxSong = new JComboBox();
			comboBoxSong.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent comboBoxSongItem) {
					if (comboBoxSongItem.getStateChange() == ItemEvent.SELECTED) {
//						System.out.println("selected");
					    populateSelectedSongInfo();
					}
				}

			});
//			comboBoxSong.addItem("Expecting to Fly");
//			comboBoxSong.addItem("California Dreaming");
//			comboBoxSong.addItem("Rainy Day Women");
		}
		return comboBoxSong;
	}
	private JSplitPane getSplitPaneSong() {
		if (splitPaneSong == null) {
			splitPaneSong = new JSplitPane();
			splitPaneSong.setOneTouchExpandable(true);
			splitPaneSong.setDividerLocation(250);
			splitPaneSong.setRightComponent(getScrollPaneSong());
			splitPaneSong.setLeftComponent(getScrollPaneLyrics());
		}
		return splitPaneSong;
	}
	private JScrollPane getScrollPaneSong() {
		if (scrollPaneSong == null) {
			scrollPaneSong = new JScrollPane();
			scrollPaneSong.setViewportView(getLblIllustration());
		}
		return scrollPaneSong;
	}
	private JLabel getLblIllustration() {
		if (lblIllustration == null) {
			lblIllustration = new JLabel("");
			lblIllustration.setHorizontalAlignment(SwingConstants.CENTER);
			lblIllustration.setIcon(new ImageIcon("C:\\Documents and Settings\\student1\\My Documents\\Expecting to Fly\\Neil-Young.jpg"));
		}
		return lblIllustration;
	}
	private JScrollPane getScrollPaneLyrics() {
		if (scrollPaneLyrics == null) {
			scrollPaneLyrics = new JScrollPane();
			scrollPaneLyrics.setViewportView(getTextAreaLyrics());
		}
		return scrollPaneLyrics;
	}
	private JTextArea getTextAreaLyrics() {
		if (textAreaLyrics == null) {
			textAreaLyrics = new JTextArea();
			textAreaLyrics.setLineWrap(true);
			textAreaLyrics.setWrapStyleWord(true);
		}
		return textAreaLyrics;
	}
	private JLabel getLblAuthor() {
		if (lblAuthor == null) {
			lblAuthor = new JLabel("Author");
			lblAuthor.setForeground(new Color(0, 51, 153));
			lblAuthor.setFont(new Font("Tahoma", Font.BOLD, 11));
		}
		return lblAuthor;
	}
	private JTextField getTextFieldAuthor() {
		if (textFieldAuthor == null) {
			textFieldAuthor = new JTextField();
			textFieldAuthor.setColumns(10);
		}
		return textFieldAuthor;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent arg0) {
			        serializeSongs();
			        JOptionPane.showMessageDialog(frmExpectingToFly, "Saved.");
			    }
			});
		}
		return btnSave;
	}
	private JRadioButton getRdbtnBasic() {
		if (rdbtnBasic == null) {
			rdbtnBasic = new JRadioButton("Basic");
			rdbtnBasic.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getCenterPanel().setVisible(false);
//					getEastPanel().setVisible(false);
					getLblAuthor().setVisible(false);
					getTextFieldAuthor().setVisible(false);
					getBtnSave().setVisible(false);
				}
			});
			buttonGroup.add(rdbtnBasic);
		}
		return rdbtnBasic;
	}
	private JRadioButton getRdbtnIllustration() {
		if (rdbtnIllustration == null) {
			rdbtnIllustration = new JRadioButton("Illustration");
			rdbtnIllustration.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getCenterPanel().setVisible(true);
//					getSplitPaneSong().setVisible(true);
//					getEastPanel().setVisible(false);
					getLblAuthor().setVisible(false);
					getTextFieldAuthor().setVisible(false);
					getBtnSave().setVisible(false);
				}
			});
			buttonGroup.add(rdbtnIllustration);
		}
		return rdbtnIllustration;
	}
	private JRadioButton getRdbtnAll() {
		if (rdbtnAll == null) {
			rdbtnAll = new JRadioButton("All");
			rdbtnAll.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getCenterPanel().setVisible(true);
//					getEastPanel().setVisible(true);
					getLblAuthor().setVisible(true);
					getTextFieldAuthor().setVisible(true);
					getBtnSave().setVisible(true);
				}
			});
			buttonGroup.add(rdbtnAll);
		}
		return rdbtnAll;
	}
	private JLabel getLblView() {
		if (lblView == null) {
			lblView = new JLabel("View");
			lblView.setFont(new Font("Tahoma", Font.BOLD, 11));
			lblView.setForeground(new Color(51, 102, 153));
		}
		return lblView;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNew());
			mnFile.add(getMntmOpen());
			mnFile.add(getMntmSave());
			mnFile.add(getSeparator());
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNew() {
		if (mntmNew == null) {
			mntmNew = new JMenuItem("New...");
			mntmNew.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newDialog = new NewDialog(frmExpectingToFly, true);
					song = newDialog.showDialog();
//					System.out.println(song);
					if (song != null) {
					    songs.add(song);
					    comboBoxSong.addItem(song.getTitle());
					    comboBoxSong.setSelectedItem(song.getTitle());
					}
				}
			});
		}
		return mntmNew;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save");
		}
		return mntmSave;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
			mntmExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					System.exit(0);
				}
			});
		}
		return mntmExit;
	}
	private JSeparator getSeparator() {
		if (separator == null) {
			separator = new JSeparator();
		}
		return separator;
	}
	
	private Song getSelectedSong() {
	    Song s = null;
	    String title = (String) getComboBoxSong().getSelectedItem();
	    for (int i = 0; i < songs.size(); i++) {
            if (songs.get(i).getTitle().equals(title)) {
                s = songs.get(i);
                break;
            }
        }
	    return s;
	}
    private void populateSelectedSongInfo() {
        Song s = getSelectedSong();
        if (s != null) {
            textAreaLyrics.setText(s.getLyrics());
            lblIllustration.setIcon(s.getIcon());
            textFieldAuthor.setText(s.getAuthor());
        }
    }
    private void serializeSongs() {
        File f = new File(Utility.mkProjectSubdir("resources"), "songs.serialized");
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            out.writeObject(songs);
            out.flush();
            out.close();
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    private void deserializeSongs() {
        File f = new File(Utility.mkProjectSubdir("resources"), "songs.serialized");
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
            songs = (LinkedList<Song>) in.readObject();
            if (songs == null) {
                songs = new LinkedList<Song>();
            }
            in.close();
        } catch (IOException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
            songs = new LinkedList<Song>();
        } catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
