package gui;

import java.awt.EventQueue;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JButton;
import java.awt.FlowLayout;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

import music.Song;

import javax.swing.border.EtchedBorder;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.GregorianCalendar;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import java.awt.Dimension;

public class NewDialog extends JDialog {
	private JPanel southPanel;
	private JButton btnOk;
	private JButton btnCancel;
	private JTabbedPane tabbedPane;
	private JPanel songPanel;
	private JPanel illustrationPanel;
	private JLabel lblTitle;
	private JTextField titleTextField;
	private JLabel lblAuthor;
	private JTextField authorTextField;
	private JLabel lblYear;
	private JTextField yearTextField;
	private JTextArea lyricsTextArea;
	private JLabel lblIllustration;
	
	private Song song;
	private NewDialog thisNewDialog = this;
	private JButton btnSelect;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NewDialog dialog = new NewDialog();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the dialog.
	 */
	public NewDialog() {
		setTitle("New");
		setBounds(800, 200, 574, 407);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);

	}

	public NewDialog(JFrame frame, boolean modal) {
		setTitle("New");
		setBounds(400, 200, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);
		this.setModal(modal);
	}

	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			FlowLayout flowLayout = (FlowLayout) southPanel.getLayout();
			flowLayout.setAlignment(FlowLayout.RIGHT);
			southPanel.add(getBtnOk());
			southPanel.add(getBtnCancel());
		}
		return southPanel;
	}
	private JButton getBtnOk() {
		if (btnOk == null) {
			btnOk = new JButton("OK");
			btnOk.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					thisNewDialog.setVisible(false);
					song = new Song();
					populateSong();
				}

				private void populateSong() {
					if (!titleTextField.getText().equals("") && (titleTextField.getText() != null)) {
						song.setTitle(titleTextField.getText());
					} else {
						song.setTitle("unknown");
					}
					
					if (!authorTextField.getText().equals("") && (authorTextField.getText() != null)) {
                        song.setAuthor(authorTextField.getText());
                    } else {
                        song.setAuthor("unknown");
                    }
					
					try {
                        int year = Integer.parseInt(yearTextField.getText());
                        song.setYear(year);
                        GregorianCalendar cal = new GregorianCalendar(year, 0, 1);  // convention: if the date is incomplete, set Jan 01 as the release date in that year
                        song.setReleaseDate(cal);
                    } catch (NumberFormatException e) {
                        // TODO Auto-generated catch block
//                        e.printStackTrace();
                        song.setYear(-1);    // convention: -1 denotes a syntax error in specifying the year of releasing the song
                        song.setReleaseDate(new GregorianCalendar()); // convention: if the release date cannot be set correctly because of a syntax error in year, set it to the current date and time
                    }
					
					if ((!lyricsTextArea.getText().equals("")) && (lyricsTextArea.getText() != null)) {
                        song.setLyrics(lyricsTextArea.getText());
                    } else {
                        song.setLyrics("unknown");
                    }
					
                    song.setIcon(lblIllustration.getIcon());
				}
			});
		}
		return btnOk;
	}
	private JButton getBtnCancel() {
		if (btnCancel == null) {
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					thisNewDialog.setVisible(false);
					song = null;
				}
			});
		}
		return btnCancel;
	}
	private JTabbedPane getTabbedPane() {
		if (tabbedPane == null) {
			tabbedPane = new JTabbedPane(JTabbedPane.TOP);
			tabbedPane.addTab("Song", null, getSongPanel(), null);
			tabbedPane.addTab("Illustration", null, getIllustrationPanel(), null);
		}
		return tabbedPane;
	}
	private JPanel getSongPanel() {
		if (songPanel == null) {
			songPanel = new JPanel();
			songPanel.setLayout(new MigLayout("", "[][grow]", "[][][][grow]"));
			songPanel.add(getLblTitle(), "cell 0 0,alignx trailing");
			songPanel.add(getTitleTextField(), "cell 1 0,growx");
			songPanel.add(getLblAuthor(), "cell 0 1,alignx trailing");
			songPanel.add(getAuthorTextField(), "cell 1 1,growx");
			songPanel.add(getLblYear(), "cell 0 2,alignx trailing");
			songPanel.add(getYearTextField(), "cell 1 2,growx");
			songPanel.add(getLyricsTextArea(), "cell 1 3,grow");
		}
		return songPanel;
	}
	private JPanel getIllustrationPanel() {
		if (illustrationPanel == null) {
			illustrationPanel = new JPanel();
			illustrationPanel.setLayout(new MigLayout("", "[grow][fill]", "[grow]"));
			illustrationPanel.add(getLblIllustration(), "cell 0 0,alignx center");
			illustrationPanel.add(getBtnSelect(), "cell 1 0,aligny top");
		}
		return illustrationPanel;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JLabel getLblAuthor() {
		if (lblAuthor == null) {
			lblAuthor = new JLabel("Author");
		}
		return lblAuthor;
	}
	private JTextField getAuthorTextField() {
		if (authorTextField == null) {
			authorTextField = new JTextField();
			authorTextField.setColumns(10);
		}
		return authorTextField;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JTextField getYearTextField() {
		if (yearTextField == null) {
			yearTextField = new JTextField();
			yearTextField.setColumns(10);
		}
		return yearTextField;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
			lyricsTextArea.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null), "Lyrics", TitledBorder.LEADING, TitledBorder.TOP, null, Color.GRAY));
		}
		return lyricsTextArea;
	}
	private JLabel getLblIllustration() {
		if (lblIllustration == null) {
			lblIllustration = new JLabel("");
			lblIllustration.setHorizontalAlignment(SwingConstants.CENTER);
//            lblIllustration.setIcon(new ImageIcon("D:\\Vladan\\Courses\\P2\\My Java Programs\\Eclipse Workspace\\Expecting to Fly\\resources\\Fender.png"));
            lblIllustration.setIcon(new ImageIcon(Utility.mkProjectSubdir("resources") + "\\Fender.png"));
		}
		return lblIllustration;
	}
	
	public Song showDialog() {
		this.setVisible(true);
		dispose();
		return song;
	}
	private JButton getBtnSelect() {
		if (btnSelect == null) {
			btnSelect = new JButton("Select...");
			btnSelect.setPreferredSize(new Dimension(100, 23));
			btnSelect.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent e) {
			        JFileChooser chooser = new JFileChooser();
			        FileNameExtensionFilter filter = new FileNameExtensionFilter(
			                "JPG & GIF Images", "png", "jpg", "jpeg", "gif");
			        chooser.setFileFilter(filter);
			        chooser.setCurrentDirectory(new File(Utility.mkProjectSubdir("resources")));
			        int returnVal = chooser.showOpenDialog(thisNewDialog);
			        if(returnVal == JFileChooser.APPROVE_OPTION) {
//			            System.out.println("You chose to open this file: " +
//			                    chooser.getSelectedFile().getName());
//			            System.out.println("You chose to open this file: " +
//			                    Utility.mkProjectSubdir("resources") + "\\" + chooser.getSelectedFile().getName());
			            lblIllustration.setIcon(new ImageIcon(Utility.mkProjectSubdir("resources") + "\\" + chooser.getSelectedFile().getName()));
			        }
			    }
			});
		}
		return btnSelect;
	}
}
