package gui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import java.awt.Dimension;
import javax.swing.border.BevelBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JTextArea;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class DemoFrame extends JFrame {

	private JPanel contentPane;
	private JPanel centralPanel;
	private JPanel topPanel;
	private JLabel lblEnterSomeText;
	private JTextField entryTextField;
	private JButton btnAddText;
	private JTextArea mainTextArea;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DemoFrame frame = new DemoFrame();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public DemoFrame() {
		setResizable(false);
		setTitle("DemoFrame");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 450, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		contentPane.add(getCentralPanel(), BorderLayout.CENTER);
		contentPane.add(getTopPanel(), BorderLayout.NORTH);
	}

	private JPanel getCentralPanel() {
		if (centralPanel == null) {
			centralPanel = new JPanel();
			centralPanel.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
			centralPanel.setLayout(new BorderLayout(0, 0));
			centralPanel.add(getMainTextArea(), BorderLayout.CENTER);
		}
		return centralPanel;
	}
	private JPanel getTopPanel() {
		if (topPanel == null) {
			topPanel = new JPanel();
			topPanel.setPreferredSize(new Dimension(10, 40));
			topPanel.add(getLblEnterSomeText());
			topPanel.add(getEntryTextField());
			topPanel.add(getBtnAddText());
		}
		return topPanel;
	}
	private JLabel getLblEnterSomeText() {
		if (lblEnterSomeText == null) {
			lblEnterSomeText = new JLabel("Enter some text:");
		}
		return lblEnterSomeText;
	}
	private JTextField getEntryTextField() {
		if (entryTextField == null) {
			entryTextField = new JTextField();
			entryTextField.setColumns(10);
		}
		return entryTextField;
	}
	private JButton getBtnAddText() {
		if (btnAddText == null) {
			btnAddText = new JButton("Add text");
			btnAddText.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String s = entryTextField.getText();
					mainTextArea.setText(s);
				}
			});
		}
		return btnAddText;
	}
	private JTextArea getMainTextArea() {
		if (mainTextArea == null) {
			mainTextArea = new JTextArea();
		}
		return mainTextArea;
	}
}
