package music;

import java.util.LinkedList;

public class Playlist {
	
	private LinkedList<Song> songs;

	public Playlist(LinkedList<Song> playlist) {
		super();
		this.songs = playlist;
	}

	public Playlist() {
		songs = new LinkedList<Song>();
	}
	
	public void addSong(Song s) {
		songs.add(s);
	}
	
	public void push(Song s) {
		songs.push(s);
	}
	
	public Song pop() {
		return songs.pop();
	}
	
	public void removeSong(Song s) {
		songs.remove(s);
	}
	
	public void playAll() throws EmptyPlaylistException {
		if (songs.size() == 0) {
			throw new EmptyPlaylistException();
		}
		for (int i = 0; i < songs.size(); i++) {
			songs.get(i).display();
		}
	}

	public LinkedList<Song> getPlaylist() {
		return songs;
	}

	public void setPlaylist(LinkedList<Song> playlist) {
		this.songs = playlist;
	}

}
