/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import weka.gui.visualize.PrintableComponent;

public class ResultHistoryPanel
extends JPanel {
    static final long serialVersionUID = 4297069440135326829L;
    protected JTextComponent m_SingleText;
    protected String m_SingleName;
    protected DefaultListModel m_Model = new DefaultListModel();
    protected JList m_List = new JList(this.m_Model);
    protected Hashtable<String, StringBuffer> m_Results = new Hashtable();
    protected Hashtable<String, JTextArea> m_FramedOutput = new Hashtable();
    protected Hashtable<String, Object> m_Objs = new Hashtable();
    protected boolean m_HandleRightClicks = true;
    protected PrintableComponent m_Printer = null;

    public ResultHistoryPanel(JTextComponent text) {
        this.m_SingleText = text;
        if (text != null) {
            this.m_Printer = new PrintableComponent(this.m_SingleText);
        }
        this.m_List.setSelectionMode(0);
        this.m_List.addMouseListener(new RMouseAdapter(){
            private static final long serialVersionUID = -9015397020486290479L;

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if ((e.getModifiers() & 0x10) == 16) {
                    int index2;
                    if ((e.getModifiers() & 0x40) == 0 && (e.getModifiers() & 0x80) == 0 && (index2 = ResultHistoryPanel.this.m_List.locationToIndex(e.getPoint())) != -1 && ResultHistoryPanel.this.m_SingleText != null) {
                        ResultHistoryPanel.this.setSingle((String)ResultHistoryPanel.this.m_Model.elementAt(index2));
                    }
                } else if (ResultHistoryPanel.this.m_HandleRightClicks && (index = ResultHistoryPanel.this.m_List.locationToIndex(e.getPoint())) != -1) {
                    String name = (String)ResultHistoryPanel.this.m_Model.elementAt(index);
                    ResultHistoryPanel.this.openFrame(name);
                }
            }
        });
        this.m_List.addKeyListener(new RKeyAdapter(){
            private static final long serialVersionUID = 7910681776999302344L;

            @Override
            public void keyReleased(KeyEvent e) {
                int selected;
                if (e.getKeyCode() == 127 && (selected = ResultHistoryPanel.this.m_List.getSelectedIndex()) != -1) {
                    ResultHistoryPanel.this.removeResult((String)ResultHistoryPanel.this.m_Model.elementAt(selected));
                }
            }
        });
        this.m_List.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || ResultHistoryPanel.this.m_SingleText == null) break;
                        ResultHistoryPanel.this.setSingle((String)ResultHistoryPanel.this.m_Model.elementAt(i));
                        break;
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_List);
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        this.add((Component)js, "Center");
    }

    public void addResult(String name, StringBuffer result) {
        this.m_Model.addElement(name);
        this.m_Results.put(name, result);
    }

    public void removeResult(String name) {
        StringBuffer buff = this.m_Results.get(name);
        if (buff != null) {
            this.m_Results.remove(name);
            this.m_Model.removeElement(name);
            this.m_Objs.remove(name);
            System.gc();
        }
    }

    public void clearResults() {
        this.m_Results.clear();
        this.m_Model.clear();
        this.m_Objs.clear();
        System.gc();
    }

    public void addObject(String name, Object o) {
        this.m_Objs.put(name, o);
    }

    public Object getNamedObject(String name) {
        Object v = null;
        v = this.m_Objs.get(name);
        return v;
    }

    public Object getSelectedObject() {
        Object v = null;
        int index = this.m_List.getSelectedIndex();
        if (index != -1) {
            String name = (String)this.m_Model.elementAt(index);
            v = this.m_Objs.get(name);
        }
        return v;
    }

    public StringBuffer getNamedBuffer(String name) {
        StringBuffer b = null;
        b = this.m_Results.get(name);
        return b;
    }

    public StringBuffer getSelectedBuffer() {
        StringBuffer b = null;
        int index = this.m_List.getSelectedIndex();
        if (index != -1) {
            String name = (String)this.m_Model.elementAt(index);
            b = this.m_Results.get(name);
        }
        return b;
    }

    public String getSelectedName() {
        int index = this.m_List.getSelectedIndex();
        if (index != -1) {
            return (String)this.m_Model.elementAt(index);
        }
        return null;
    }

    public String getNameAtIndex(int index) {
        if (index != -1) {
            return (String)this.m_Model.elementAt(index);
        }
        return null;
    }

    public void setSingle(String name) {
        StringBuffer buff = this.m_Results.get(name);
        if (buff != null) {
            this.m_SingleName = name;
            this.m_SingleText.setText(buff.toString());
            this.m_List.setSelectedValue(name, true);
        }
    }

    public void setSelectedListValue(String name) {
        this.m_List.setSelectedValue(name, true);
    }

    public void openFrame(String name) {
        StringBuffer buff = this.m_Results.get(name);
        JTextComponent currentText = this.m_FramedOutput.get(name);
        if (buff != null && currentText == null) {
            JTextArea ta = new JTextArea();
            ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ta.setFont(new Font("Monospaced", 0, 12));
            ta.setEditable(false);
            ta.setText(buff.toString());
            this.m_FramedOutput.put(name, ta);
            final JFrame jf = new JFrame(name);
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ResultHistoryPanel.this.m_FramedOutput.remove(jf.getTitle());
                    jf.dispose();
                }
            });
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)new JScrollPane(ta), "Center");
            jf.pack();
            jf.setSize(450, 350);
            jf.setVisible(true);
        }
    }

    public void updateResult(String name) {
        JTextComponent currentText;
        StringBuffer buff = this.m_Results.get(name);
        if (buff == null) {
            return;
        }
        if (this.m_SingleName == name) {
            this.m_SingleText.setText(buff.toString());
        }
        if ((currentText = (JTextComponent)this.m_FramedOutput.get(name)) != null) {
            currentText.setText(buff.toString());
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_List.getSelectionModel();
    }

    public JList getList() {
        return this.m_List;
    }

    public void setHandleRightClicks(boolean tf) {
        this.m_HandleRightClicks = tf;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.m_List != null) {
            this.m_List.setBackground(c);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.m_List != null) {
            this.m_List.setFont(f);
        }
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: Classifier");
            jf.getContentPane().setLayout(new BorderLayout());
            ResultHistoryPanel jd = new ResultHistoryPanel(null);
            jd.addResult("blah", new StringBuffer("Nothing to see here"));
            jd.addResult("blah1", new StringBuffer("Nothing to see here1"));
            jd.addResult("blah2", new StringBuffer("Nothing to see here2"));
            jd.addResult("blah3", new StringBuffer("Nothing to see here3"));
            jf.getContentPane().add((Component)jd, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class RKeyAdapter
    extends KeyAdapter
    implements Serializable {
        static final long serialVersionUID = -8675332541861828079L;
    }

    public static class RMouseAdapter
    extends MouseAdapter
    implements Serializable {
        static final long serialVersionUID = -8991922650552358669L;
    }
}

