package rs.ac.bg.fon.ai.dataPreparation;

import java.util.Enumeration;

import weka.attributeSelection.BestFirst;
import weka.attributeSelection.WrapperSubsetEval;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;

public class AttributeSelectionExample {

	private static String fileName = "data/census90-income.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// printing all attributes from new instance set
		System.out.println("The initial set of attributes");
		System.out.println("----------------------------");
		printAttributeLabels(data);
		System.out.println("Total number of attributes (before selection): " + data.numAttributes());
		
		// creating a classifier instance
		NaiveBayes nbClsf = new NaiveBayes();
		nbClsf.buildClassifier(data);
		nbClsf.setUseSupervisedDiscretization(true);
		
		// creating evaluator wrapped around the classifier
		WrapperSubsetEval wrappedEval = new WrapperSubsetEval();
		wrappedEval.setClassifier(nbClsf);
		
		// creating a filter of the type AttributeSelection and setting evaluator and search method
		AttributeSelection attSelectFilter = new AttributeSelection();
		attSelectFilter.setEvaluator(wrappedEval);
		attSelectFilter.setSearch(new BestFirst());
		attSelectFilter.setInputFormat(data);
		
		// applying the filter and getting a new instance set as the result
		Instances filteredData = Filter.useFilter(data, attSelectFilter);
		
		
		// printing all attributes from new instance set
		System.out.println("\n\n----------------------------");
		System.out.println("New attributes");
		System.out.println("----------------------------");
		printAttributeLabels(filteredData);
		System.out.println("Number of attributes after selection: " + filteredData.numAttributes());
				
	}

	private static void printAttributeLabels(Instances dataset) {	
		Enumeration<Attribute> enumerateAttributes = dataset.enumerateAttributes();
		while (enumerateAttributes.hasMoreElements()) {
			Attribute a = (Attribute) enumerateAttributes.nextElement();
			System.out.println("- " + a.name() + ": " + Attribute.typeToString(a));
		}
	}
	
}
