package rs.ac.bg.fon.ai.dataPreparation;


import java.text.DecimalFormat;
import java.util.Random;

import weka.classifiers.Evaluation;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class CrossValidationExample {
	
	private static String fileName = "data/diabetes.arff";
	
	public static void main(String[] args) throws Exception {
		
		// reading dataset from file
		DataSource dataSrc = new DataSource(fileName);
		Instances data = dataSrc.getDataSet();
		data.setClassIndex(data.numAttributes()-1);
		
		// prepare the dataset for stratified cross-validation (CV)
		// randomize the order of instances in the dataset
		int seed = 9;  								// setting the seed guarantees that the random number generator 
		Random randomizer = new Random(seed);		// will always generate the same "random" numbers
		Instances randomizedData = new Instances(data);
		randomizedData.randomize(randomizer);
		
		int numFolds = 10;		// the number of folds in CV
		randomizedData.stratify(numFolds); 
		
		NaiveBayes nbClsf = new NaiveBayes();
		
		// do the cross-validation 
		int positiveCls = 1;
		double precisionTot = 0, recallTot = 0, accuracyTot = 0;
		
		for (int i = 0; i < numFolds; i++) {
			Instances trainFolds = randomizedData.trainCV(numFolds, i);
			Instances testFold = randomizedData.testCV(numFolds, i);
			
			nbClsf.setUseSupervisedDiscretization(true);
			nbClsf.buildClassifier(trainFolds);
			
			Evaluation nbEval = new Evaluation(testFold);
			nbEval.evaluateModel(nbClsf, testFold);
			
			System.out.println("\n" + (i+1) + ". iteration:");
			printEvalMeasures(nbEval.precision(positiveCls), nbEval.recall(positiveCls), nbEval.pctCorrect());
			
			precisionTot += nbEval.precision(positiveCls);
			recallTot += nbEval.recall(positiveCls);
			accuracyTot += nbEval.pctCorrect();
		}
		
		// print the mean values of the evaluation metrics 
		// based on all the iterations of the CV process
		System.out.println("\n----------------------------------------");
		System.out.println("Average metric values:");
		printEvalMeasures(precisionTot/numFolds, recallTot/numFolds, accuracyTot/numFolds);
		
	}
	
	private static void printEvalMeasures(double precision, double recall, double accuracy) {
		
		DecimalFormat formatter = new DecimalFormat();
		
		System.out.println("Accuracy:\t" + formatter.format(accuracy/100));
		System.out.println("Precision:\t" + formatter.format(precision));
		System.out.println("Recall:\t\t" + formatter.format(recall));
		
	}
}
