package rs.ac.bg.fon.ai.dataPreparation;

import java.text.DecimalFormat;
import java.util.Enumeration;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class NormalizeExample {

	private static String fileName = "data/weather.numeric.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating a filter for normalization
		Normalize normalizeFilter = new Normalize();
		normalizeFilter.setScale(2);	// scale is usually 1, but can be overridden
		normalizeFilter.setInputFormat(data);
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, normalizeFilter);
		
		//printing values of the two numerical attributes after normalization
		int[] attributeIndexes = {0,1};
		printAttributeValues(outputTrain, attributeIndexes);
		
		
	}
	
	private static void printAttributeValues(Instances dataset, int[] attributeIndexes) {		
		
		//print attribute names
		for (int i = 0; i < attributeIndexes.length; i++) {
			if ( i== attributeIndexes.length-1 )
				System.out.println(dataset.attribute(i).name());
			else System.out.print(dataset.attribute(i).name() + "\t\t");
		}
		
		// print attribute values
		Enumeration<Instance> instanceEnum = dataset.enumerateInstances();
		while (instanceEnum.hasMoreElements()) {
			Instance i = (Instance) instanceEnum.nextElement();
			
			for (int j = 0; j < attributeIndexes.length; j++) {
				double iVal = i.value(attributeIndexes[j]);
				System.out.print(new DecimalFormat().format(iVal));
				if ( j== attributeIndexes.length-1 )
					System.out.println();
				else System.out.print("\t\t");
			}
			
		}
		
	}

}
