package rs.ac.bg.fon.ai.dataPreparation;

import java.text.DecimalFormat;
import java.util.Enumeration;

import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.Standardize;

public class RemoveAndStandardizeExample {

	private static String fileName = "data/weather.numeric.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating Remove filter in order to exclude one (or more) attributes
		Remove removeFilter = new Remove();
		// exclude nominal attributes
		int[] toRemove = {0,3};
		removeFilter.setAttributeIndicesArray(toRemove);		
		removeFilter.setInputFormat(data);
		
		// creating a filter for standardization
		Standardize standardizeFilter = new Standardize();
		standardizeFilter.setInputFormat(data);
		
		// creating a multifilter in order to chain filter execution
		MultiFilter multiFilter = new MultiFilter();
		multiFilter.setInputFormat(data);
		multiFilter.setFilters(new Filter[]{removeFilter, standardizeFilter});
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, multiFilter);
		
		// print the attributes that are left in the data
		printAttributeLabels(outputTrain);
		// print the attribute values
		printAttributeValues(outputTrain, new int[] {1,2});
	}
	
	private static void printAttributeLabels(Instances dataset) {
		Enumeration<Attribute> enumerateAttributes = dataset.enumerateAttributes();
		while (enumerateAttributes.hasMoreElements()) {
			Attribute a = (Attribute)enumerateAttributes.nextElement();
			System.out.println(a);
		}
	}
	
	private static void printAttributeValues(Instances dataset, int[] attributeIndexes) {		
		
		//print attribute names
		for (int i = 0; i < attributeIndexes.length; i++) {
			if ( i== attributeIndexes.length-1 )
				System.out.println(dataset.attribute(i).name());
			else System.out.print(dataset.attribute(i).name() + "\t\t");
		}
		
		// print attribute values
		Enumeration<Instance> instanceEnum = dataset.enumerateInstances();
		while (instanceEnum.hasMoreElements()) {
			Instance i = (Instance) instanceEnum.nextElement();
			
			for (int j = 0; j < attributeIndexes.length; j++) {
				double iVal = i.value(attributeIndexes[j]);
				System.out.print(new DecimalFormat().format(iVal));
				if ( j== attributeIndexes.length-1 )
					System.out.println();
				else System.out.print("\t\t");
			}
			
		}
		
	}
}
