package rs.ac.bg.fon.ai.dataPreparation;

import java.util.Enumeration;

import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class SupervisedDiscretizationExample {

	private static String fileName = "data/diabetes.arff";

	public static void main(String[] args) throws Exception {
		
		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating a supervised discretization filter 
		// IMPORTANT: note that this Discretize class comes from weka.filters.supervised.attribute package
		// for unsupervised discretization we used Discretize class from the weka.filters.unsupervised.attribute package 
		Discretize discretizeFilter = new Discretize(); 
		discretizeFilter.setAttributeIndices("first-last");
		discretizeFilter.setInputFormat(data);
		
		Instances filteredDataset = Filter.useFilter(data, discretizeFilter);
		
		// let's examine the values of one of the attributes after discretization
		Attribute attribute = filteredDataset.attribute(5);
				
		Enumeration<Object> attEnum = attribute.enumerateValues();
		while (attEnum.hasMoreElements()) {
			String attVal = (String) attEnum.nextElement();		
			System.out.println(attVal);
		}
	}
}
