/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.assembler;

import java.util.Locale;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.lib.ColumnMap;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.assembler.VocabTDB;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.IndexFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.store.tupletable.TupleIndexRecord;
import org.apache.jena.tdb.sys.SystemTDB;

public class IndexAssembler
extends AssemblerBase {
    private Location location = null;

    private IndexAssembler() {
        this.location = null;
    }

    private IndexAssembler(Location location) {
        this.location = location;
    }

    public TupleIndex open(Assembler a, Resource root, Mode mode) {
        GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabTDB.pDescription);
        String desc = GraphUtils.getAsStringValue((Resource)root, (Property)VocabTDB.pDescription).toUpperCase(Locale.ENGLISH);
        GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabTDB.pFile);
        String filename = GraphUtils.getAsStringValue((Resource)root, (Property)VocabTDB.pFile);
        if (this.location != null) {
            filename = this.location.absolute(filename);
        }
        String primary = null;
        RecordFactory rf = null;
        switch (desc.length()) {
            case 3: {
                primary = "SPO";
                rf = SystemTDB.indexRecordTripleFactory;
                break;
            }
            case 4: {
                primary = "GSPO";
                rf = SystemTDB.indexRecordQuadFactory;
                break;
            }
            default: {
                throw new TDBException("Bad length for index description: " + desc);
            }
        }
        FileSet fileset = null;
        StoreParams idxParams = StoreParams.getDftStoreParams();
        RangeIndex rIndex = IndexFactory.buildRangeIndex(fileset, rf, idxParams);
        return new TupleIndexRecord(desc.length(), new ColumnMap(primary, desc), desc, rf, rIndex);
    }
}

