/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import java.util.Iterator;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.SetupIndex;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.index.bplustree.BPlusTreeRewriter;

public class CmdRewriteIndex {
    public static void main(String ... argv) {
        int dftValueLength;
        int dftKeyLength;
        if (argv.length != 3) {
            System.err.println("Usage: " + Lib.classShortName(CmdRewriteIndex.class) + " SrcLocation DstLocation IndexName");
            System.exit(1);
        }
        Location srcLoc = Location.create(argv[0]);
        Location dstLoc = Location.create(argv[1]);
        String indexName = argv[2];
        if (!FileOps.exists((String)argv[1])) {
            System.err.println("Destination directory does not exist");
            System.exit(1);
        }
        if (FileOps.exists((String)dstLoc.getPath(indexName, "idn"))) {
            System.err.println("Destination contains an index of that name");
            System.exit(1);
        }
        FileSet destination = new FileSet(dstLoc, indexName);
        int readCacheSize = 0;
        int writeCacheSize = -1;
        if (indexName.length() == 3) {
            dftKeyLength = 24;
            dftValueLength = 0;
        } else if (indexName.length() == 4) {
            dftKeyLength = 32;
            dftValueLength = 0;
        } else {
            System.err.printf("Can't determine record size for %s\n", indexName);
            return;
        }
        RecordFactory recordFactory = null;
        BPlusTreeParams bptParams = null;
        int blockSize = 8192;
        RangeIndex rangeIndex = SetupIndex.makeRangeIndex(srcLoc, indexName, blockSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
        BPlusTree bpt = (BPlusTree)rangeIndex;
        bptParams = bpt.getParams();
        recordFactory = bpt.getRecordFactory();
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", blockSizeNodes, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", blockSizeRecords, readCacheSize, writeCacheSize);
        Iterator<Record> iterator = bpt.iterator();
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(iterator, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
        if (bpt2 == null) {
            return;
        }
        bpt2.close();
    }
}

