/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModRemote;
import arq.cmdline.ModResultsOut;
import jena.cmd.ArgModuleGeneral;
import jena.cmd.CmdException;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.engine.http.HttpQuery;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.util.QueryExecUtils;

public class rsparql
extends CmdARQ {
    protected ModQueryIn modQuery = new ModQueryIn(Syntax.syntaxSPARQL_11);
    protected ModRemote modRemote = new ModRemote();
    protected ModResultsOut modResults = new ModResultsOut();

    public static void main(String ... argv) {
        new rsparql(argv).mainRun();
    }

    public rsparql(String[] argv) {
        super(argv);
        super.addModule((ArgModuleGeneral)this.modRemote);
        super.addModule((ArgModuleGeneral)this.modQuery);
        super.addModule((ArgModuleGeneral)this.modResults);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.modRemote.getServiceURL() == null) {
            throw new CmdException("No SPARQL endpoint specificied");
        }
    }

    protected void exec() {
        Query query2 = this.modQuery.getQuery();
        try {
            String serviceURL = this.modRemote.getServiceURL();
            QueryExecution qe = QueryExecutionFactory.sparqlService(serviceURL, query2);
            if (this.modRemote.usePost()) {
                HttpQuery.urlLimit = 0;
            }
            QueryExecUtils.executeQuery(query2, qe, this.modResults.getResultsFormat());
        }
        catch (QueryExceptionHTTP ex) {
            throw new CmdException("HTTP Exeception", (Throwable)((Object)ex));
        }
        catch (Exception ex) {
            System.out.flush();
            ex.printStackTrace(System.err);
        }
    }

    protected String getSummary() {
        return null;
    }
}

