/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.GLib;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterConst;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class TurtleShell {
    protected final IndentedWriter out;
    protected final NodeFormatter nodeFmt;
    protected final PrefixMap prefixMap;
    protected final String baseURI;
    private static Comparator<Node> compPredicates = new ComparePredicates();

    protected TurtleShell(IndentedWriter out, PrefixMap pmap, String baseURI) {
        this.out = out;
        if (pmap == null) {
            pmap = PrefixMapFactory.emptyPrefixMap();
        }
        this.nodeFmt = new NodeFormatterTTL(baseURI, pmap, NodeToLabel.createScopeByDocument());
        this.prefixMap = pmap;
        this.baseURI = baseURI;
    }

    protected void writeBase(String base) {
        RiotLib.writeBase(this.out, base);
    }

    protected void writePrefixes(PrefixMap prefixMap) {
        RiotLib.writePrefixes(this.out, prefixMap);
    }

    protected void writeGraphTTL(Graph graph) {
        ShellGraph x = new ShellGraph(graph, null, null);
        x.writeGraph();
    }

    protected void writeGraphTTL(DatasetGraph dsg, Node graphName) {
        Graph g = graphName == null || Quad.isDefaultGraph(graphName) ? dsg.getDefaultGraph() : dsg.getGraph(graphName);
        ShellGraph x = new ShellGraph(g, graphName, dsg);
        x.writeGraph();
    }

    protected final void writeNode(Node node) {
        this.nodeFmt.format((AWriter)this.out, node);
    }

    private void print(String x) {
        this.out.print(x);
    }

    private void gap(int gap) {
        this.out.print(' ', gap);
    }

    private void println() {
        this.out.println();
    }

    private static final class ComparePredicates
    implements Comparator<Node> {
        private ComparePredicates() {
        }

        private static int classification(Node p) {
            if (p.equals((Object)WriterConst.RDF_type)) {
                return 0;
            }
            if (p.getURI().startsWith(RDF.getURI()) || p.getURI().startsWith(RDFS.getURI())) {
                return 1;
            }
            return 2;
        }

        @Override
        public int compare(Node t1, Node t2) {
            int class2;
            int class1 = ComparePredicates.classification(t1);
            if (class1 != (class2 = ComparePredicates.classification(t2))) {
                if (class1 < class2) {
                    return -1;
                }
                if (class1 > class2) {
                    return 1;
                }
                return 0;
            }
            String p1 = t1.getURI();
            String p2 = t2.getURI();
            return p1.compareTo(p2);
        }
    }

    private final class ShellGraph {
        private final DatasetGraph dsg;
        private final Collection<Node> graphNames;
        private final Node graphName;
        private final Graph graph;
        private Set<Node> nestedObjects;
        private final Set<Node> nestedObjectsWritten;
        private final Set<Node> freeBnodes;
        private Map<Node, List<Node>> lists;
        private final Map<Node, List<Node>> freeLists;
        private final Map<Node, List<Node>> nLinkedLists;
        private final Collection<Node> listElts;
        private boolean allowDeepPretty = true;

        private ShellGraph(Graph graph, Node graphName, DatasetGraph dsg) {
            this.dsg = dsg;
            this.graphName = graphName;
            this.graphNames = dsg != null ? Iter.toSet(dsg.listGraphNodes()) : null;
            this.graph = graph;
            this.nestedObjects = new HashSet<Node>();
            this.nestedObjectsWritten = new HashSet<Node>();
            this.freeBnodes = new HashSet<Node>();
            this.lists = new HashMap<Node, List<Node>>();
            this.freeLists = new HashMap<Node, List<Node>>();
            this.nLinkedLists = new HashMap<Node, List<Node>>();
            this.listElts = new HashSet<Node>();
            this.allowDeepPretty = true;
            this.findLists();
            this.findBNodesSyntax1();
            this.nestedObjects.removeAll(this.listElts);
        }

        private void printDetails() {
            this.printDetails("nestedObjects", this.nestedObjects);
            this.printDetails("freeBnodes", this.freeBnodes);
            this.printDetails("lists", this.lists);
            this.printDetails("freeLists", this.freeLists);
            this.printDetails("nLinkedLists", this.nLinkedLists);
            this.printDetails("listElts", this.listElts);
        }

        private void printDetails(String label, Map<Node, List<Node>> map) {
            System.err.print("## ");
            System.err.print(label);
            System.err.print(" = ");
            System.err.println(map);
        }

        private void printDetails(String label, Collection<Node> nodes) {
            System.err.print("## ");
            System.err.print(label);
            System.err.print(" = ");
            System.err.println(nodes);
        }

        private ShellGraph(Graph graph) {
            this(graph, null, null);
        }

        private List<Triple> triples(Node s, Node p, Node o) {
            ArrayList<Triple> acc = new ArrayList<Triple>();
            RiotLib.accTriples(acc, this.graph, s, p, o);
            return acc;
        }

        private Triple triple1(Node s, Node p, Node o) {
            if (this.dsg != null) {
                return RiotLib.triple1(this.dsg, s, p, o);
            }
            return RiotLib.triple1(this.graph, s, p, o);
        }

        private Triple triple1(DatasetGraph dsg, Node s, Node p, Node o) {
            Iterator<Quad> iter = dsg.find(Node.ANY, s, p, o);
            if (!iter.hasNext()) {
                return null;
            }
            Quad q = iter.next();
            if (iter.hasNext()) {
                return null;
            }
            return q.asTriple();
        }

        private long countTriples(Node s, Node p, Node o) {
            if (this.dsg != null) {
                return RiotLib.countTriples(this.dsg, s, p, o);
            }
            return RiotLib.countTriples(this.graph, s, p, o);
        }

        private ExtendedIterator<Triple> find(Node s, Node p, Node o) {
            return this.graph.find(s, p, o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int inLinks(Node obj) {
            if (this.dsg != null) {
                Iterator<Quad> iter = this.dsg.find(Node.ANY, Node.ANY, Node.ANY, obj);
                return this.count012(iter);
            }
            try (ExtendedIterator iter = this.graph.find(Node.ANY, Node.ANY, obj);){
                int n = this.count012((Iterator<?>)iter);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int occursAsSubject(Node subj) {
            if (this.dsg != null) {
                Iterator<Quad> iter = this.dsg.find(Node.ANY, subj, Node.ANY, Node.ANY);
                return this.count012(iter);
            }
            try (ExtendedIterator iter = this.graph.find(subj, Node.ANY, Node.ANY);){
                int n = this.count012((Iterator<?>)iter);
                return n;
            }
        }

        private int count012(Iterator<?> iter) {
            if (!iter.hasNext()) {
                return 0;
            }
            iter.next();
            if (!iter.hasNext()) {
                return 1;
            }
            return 2;
        }

        private boolean containedInOneGraph(Node node) {
            if (this.dsg == null) {
                return true;
            }
            if (this.graphNames.contains(node)) {
                return false;
            }
            Iterator<Quad> iter = this.dsg.find(Node.ANY, node, Node.ANY, Node.ANY);
            if (!this.quadsThisGraph(iter)) {
                return false;
            }
            iter = this.dsg.find(Node.ANY, Node.ANY, node, Node.ANY);
            if (!this.quadsThisGraph(iter)) {
                return false;
            }
            iter = this.dsg.find(Node.ANY, Node.ANY, Node.ANY, node);
            return this.quadsThisGraph(iter);
        }

        private boolean quadsThisGraph(Iterator<Quad> iter) {
            if (!iter.hasNext()) {
                return true;
            }
            Quad q = iter.next();
            Node gn = q.getGraph();
            if (this.isDefaultGraph(gn) ? !this.isDefaultGraph(this.graphName) : !Objects.equals(gn, this.graphName)) {
                return false;
            }
            while (iter.hasNext()) {
                Quad q2 = iter.next();
                if (Objects.equals(gn, q2.getGraph())) continue;
                return false;
            }
            return true;
        }

        private boolean isDefaultGraph(Node node) {
            return node == null || Quad.isDefaultGraph(node);
        }

        private Collection<Triple> triplesOfSubject(Node subj) {
            return RiotLib.triplesOfSubject(this.graph, subj);
        }

        private Iterator<Node> listSubjects() {
            return GLib.listSubjects(this.graph);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findBNodesSyntax1() {
            HashSet<Node> rejects = new HashSet<Node>();
            try (ExtendedIterator<Triple> iter = this.find(Node.ANY, Node.ANY, Node.ANY);){
                while (iter.hasNext()) {
                    int sConn;
                    Triple t = (Triple)iter.next();
                    Node subj = t.getSubject();
                    Node obj = t.getObject();
                    if (this.listElts.contains(subj) || this.listElts.contains(obj)) continue;
                    if (subj.isBlank() && (sConn = this.inLinks(subj)) == 0 && this.containedInOneGraph(subj)) {
                        this.freeBnodes.add(subj);
                    }
                    if (!obj.isBlank() || rejects.contains(obj)) continue;
                    int connectivity = this.inLinks(obj);
                    if (connectivity == 1 && this.containedInOneGraph(obj)) {
                        this.nestedObjects.add(obj);
                        continue;
                    }
                    rejects.add(obj);
                }
            }
        }

        private void findLists() {
            List<Triple> tails = this.triples(Node.ANY, WriterConst.RDF_Rest, WriterConst.RDF_Nil);
            for (Triple t : tails) {
                HashSet<Node> listElts2 = new HashSet<Node>();
                Pair<Node, List<Node>> p = this.followTailToHead(t.getSubject(), listElts2);
                if (p == null) continue;
                Node headElt = (Node)p.getLeft();
                List elts = (List)p.getRight();
                long numLinks = this.countTriples(null, null, headElt);
                if (numLinks == 1L) {
                    this.lists.put(headElt, elts);
                } else if (numLinks == 0L) {
                    this.freeLists.put(headElt, elts);
                } else {
                    this.nLinkedLists.put(headElt, elts);
                }
                this.listElts.addAll(listElts2);
            }
        }

        private Pair<Node, List<Node>> followTailToHead(Node lastListElt, Collection<Node> listElts) {
            ArrayList<Node> listCells = new ArrayList<Node>();
            ArrayList<Node> eltsReversed = new ArrayList<Node>();
            ArrayList<Triple> acc = new ArrayList<Triple>();
            Node x = lastListElt;
            while (true) {
                if (!this.validListElement(x, acc)) {
                    if (listCells.size() == 0) {
                        return null;
                    }
                    x = (Node)listCells.remove(listCells.size() - 1);
                    break;
                }
                Triple t = this.triple1(x, WriterConst.RDF_First, null);
                if (t == null) {
                    return null;
                }
                eltsReversed.add(t.getObject());
                listCells.add(x);
                List<Triple> acc2 = this.triples(null, null, x);
                long numRest = this.countTriples(null, WriterConst.RDF_Rest, x);
                if (numRest != 1L) {
                    listCells.add(x);
                    break;
                }
                int numLinks = acc2.size();
                if (numLinks > 1) break;
                Triple tLink = acc2.get(0);
                x = tLink.getSubject();
            }
            listElts.addAll(listCells);
            Collections.reverse(eltsReversed);
            return Pair.create((Object)x, eltsReversed);
        }

        private boolean validListElement(Node x, List<Triple> acc) {
            Triple t1 = this.triple1(x, WriterConst.RDF_Rest, null);
            if (t1 == null) {
                return false;
            }
            Triple t2 = this.triple1(x, WriterConst.RDF_First, null);
            if (t2 == null) {
                return false;
            }
            long N = this.countTriples(x, null, null);
            if (N != 2L) {
                return false;
            }
            acc.add(t1);
            acc.add(t2);
            return true;
        }

        private void writeGraph() {
            Iterator<Node> subjects = this.listSubjects();
            boolean somethingWritten = this.writeBySubject(subjects);
            somethingWritten = this.writeRemainingNLinkedLists(somethingWritten);
            somethingWritten = this.writeRemainingFreeLists(somethingWritten);
            Set singleNodes = SetUtils.difference(this.nestedObjects, this.nestedObjectsWritten);
            somethingWritten = this.writeRemainingNestedObjects(singleNodes, somethingWritten);
        }

        private boolean writeRemainingNLinkedLists(boolean somethingWritten) {
            for (Node n : this.nLinkedLists.keySet()) {
                if (somethingWritten) {
                    TurtleShell.this.out.println();
                }
                somethingWritten = true;
                List<Node> x = this.nLinkedLists.get(n);
                TurtleShell.this.writeNode(n);
                this.write_S_P_Gap();
                TurtleShell.this.out.pad();
                TurtleShell.this.writeNode(WriterConst.RDF_First);
                TurtleShell.this.print(" ");
                TurtleShell.this.writeNode(x.get(0));
                TurtleShell.this.print(" ;");
                TurtleShell.this.println();
                TurtleShell.this.writeNode(WriterConst.RDF_Rest);
                TurtleShell.this.print("  ");
                x = x.subList(1, x.size());
                this.list(x);
                TurtleShell.this.print(" .");
                TurtleShell.this.out.decIndent(8);
                TurtleShell.this.println();
            }
            return somethingWritten;
        }

        private boolean writeRemainingFreeLists(boolean somethingWritten) {
            for (Node n : this.freeLists.keySet()) {
                if (somethingWritten) {
                    TurtleShell.this.out.println();
                }
                somethingWritten = true;
                List<Node> x = this.freeLists.get(n);
                TurtleShell.this.out.print("[ ");
                TurtleShell.this.writeNode(WriterConst.RDF_First);
                TurtleShell.this.print(" ");
                TurtleShell.this.writeNode(x.get(0));
                TurtleShell.this.print(" ; ");
                TurtleShell.this.writeNode(WriterConst.RDF_Rest);
                TurtleShell.this.print(" ");
                x = x.subList(1, x.size());
                this.list(x);
                TurtleShell.this.out.println(" ] .");
            }
            return somethingWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeRemainingNestedObjects(Set<Node> objects, boolean somethingWritten) {
            for (Node n : objects) {
                if (somethingWritten) {
                    TurtleShell.this.out.println();
                }
                somethingWritten = true;
                Triple t = this.triple1(null, null, n);
                if (t == null) {
                    throw new InternalErrorException("Expected exactly one triple");
                }
                Node subj = t.getSubject();
                boolean b = this.allowDeepPretty;
                try {
                    this.allowDeepPretty = false;
                    List<Triple> triples = this.triples(subj, null, null);
                    this.writeCluster(subj, triples);
                }
                finally {
                    this.allowDeepPretty = b;
                }
            }
            return somethingWritten;
        }

        private void writeTriples(Node subj, Iterator<Triple> iter) {
            this.allowDeepPretty = false;
            this.writeCluster(subj, Iter.toList(iter));
        }

        private boolean writeBySubject(Iterator<Node> subjects) {
            boolean first = true;
            while (subjects.hasNext()) {
                Node subj = subjects.next();
                if (this.nestedObjects.contains(subj) || this.listElts.contains(subj)) continue;
                if (!first) {
                    TurtleShell.this.out.println();
                }
                first = false;
                if (this.freeBnodes.contains(subj)) {
                    this.writeNestedObject(subj);
                    TurtleShell.this.out.println(" .");
                    continue;
                }
                Collection<Triple> cluster = this.triplesOfSubject(subj);
                this.writeCluster(subj, cluster);
            }
            return !first;
        }

        private void writeCluster(Node subject, Collection<Triple> cluster) {
            if (cluster.isEmpty()) {
                return;
            }
            TurtleShell.this.writeNode(subject);
            this.write_S_P_Gap();
            TurtleShell.this.out.incIndent(8);
            TurtleShell.this.out.pad();
            this.writePredicateObjectList(cluster);
            TurtleShell.this.out.decIndent(8);
            TurtleShell.this.print(" .");
            TurtleShell.this.println();
        }

        private void writePredicateObjectList(Collection<Triple> cluster) {
            Map<Node, List<Node>> pGroups = this.groupByPredicates(cluster);
            Set<Node> predicates = pGroups.keySet();
            int predicateMaxWidth = RiotLib.calcWidth(TurtleShell.this.prefixMap, TurtleShell.this.baseURI, predicates, 4, 30);
            boolean first = true;
            if (!WriterConst.OBJECT_LISTS) {
                for (Node p : predicates) {
                    for (Node o : pGroups.get(p)) {
                        this.writePredicateObject(p, o, predicateMaxWidth, first);
                        first = false;
                    }
                }
                return;
            }
            for (Node p : predicates) {
                ArrayList<Node> rdfLiterals = new ArrayList<Node>();
                ArrayList<Node> rdfSimpleNodes = new ArrayList<Node>();
                ArrayList<Node> rdfComplexNodes = new ArrayList<Node>();
                for (Node o : pGroups.get(p)) {
                    if (o.isLiteral()) {
                        rdfLiterals.add(o);
                        continue;
                    }
                    if (this.isPrettyNode(o)) {
                        rdfComplexNodes.add(o);
                        continue;
                    }
                    rdfSimpleNodes.add(o);
                }
                if (rdfLiterals.size() != 0) {
                    this.writePredicateObjectList(p, rdfLiterals, predicateMaxWidth, first);
                    first = false;
                }
                if (rdfSimpleNodes.size() != 0) {
                    this.writePredicateObjectList(p, rdfSimpleNodes, predicateMaxWidth, first);
                    first = false;
                }
                for (Node o : rdfComplexNodes) {
                    this.writePredicateObject(p, o, predicateMaxWidth, first);
                    first = false;
                }
            }
        }

        private void writePredicateObject(Node p, Node obj, int predicateMaxWidth, boolean first) {
            this.writePredicate(p, predicateMaxWidth, first);
            TurtleShell.this.out.incIndent(8);
            this.writeNodePretty(obj);
            TurtleShell.this.out.decIndent(8);
        }

        private void writePredicateObjectList(Node p, List<Node> objects, int predicateMaxWidth, boolean first) {
            this.writePredicate(p, predicateMaxWidth, first);
            TurtleShell.this.out.incIndent(8);
            boolean firstObject = true;
            for (Node o : objects) {
                if (!firstObject) {
                    TurtleShell.this.out.print(" , ");
                } else {
                    firstObject = false;
                }
                TurtleShell.this.writeNode(o);
            }
            TurtleShell.this.out.decIndent(8);
        }

        private void writePredicate(Node p, int predicateMaxWidth, boolean first) {
            if (first) {
                first = false;
            } else {
                TurtleShell.this.print(" ;");
                TurtleShell.this.println();
            }
            int colPredicateStart = TurtleShell.this.out.getAbsoluteIndent();
            if (!TurtleShell.this.prefixMap.contains(WriterConst.rdfNS) && WriterConst.RDF_type.equals((Object)p)) {
                TurtleShell.this.print("a");
            } else {
                TurtleShell.this.writeNode(p);
            }
            int colPredicateFinish = TurtleShell.this.out.getCol();
            int wPredicate = colPredicateFinish - colPredicateStart;
            if (wPredicate > 30) {
                TurtleShell.this.println();
            } else {
                TurtleShell.this.out.pad(predicateMaxWidth);
                TurtleShell.this.gap(2);
            }
        }

        private Map<Node, List<Node>> groupByPredicates(Collection<Triple> cluster) {
            TreeMap<Node, List<Node>> x = new TreeMap<Node, List<Node>>(compPredicates);
            for (Triple t : cluster) {
                Node p = t.getPredicate();
                if (!x.containsKey(p)) {
                    x.put(p, new ArrayList());
                }
                ((List)x.get(p)).add(t.getObject());
            }
            return x;
        }

        private int countPredicates(Collection<Triple> cluster) {
            HashSet<Node> x = new HashSet<Node>();
            for (Triple t : cluster) {
                Node p = t.getPredicate();
                x.add(p);
            }
            return x.size();
        }

        private void writeNestedObject(Node node) {
            Collection<Triple> x = this.triplesOfSubject(node);
            if (x.isEmpty()) {
                TurtleShell.this.print("[] ");
                return;
            }
            int pCount = this.countPredicates(x);
            if (pCount == 1) {
                TurtleShell.this.print("[ ");
                TurtleShell.this.out.incIndent(2);
                this.writePredicateObjectList(x);
                TurtleShell.this.out.decIndent(2);
                TurtleShell.this.print(" ]");
                return;
            }
            int indent0 = TurtleShell.this.out.getAbsoluteIndent();
            int here = TurtleShell.this.out.getCol();
            TurtleShell.this.out.setAbsoluteIndent(here);
            TurtleShell.this.print("[ ");
            TurtleShell.this.out.incIndent(2);
            this.writePredicateObjectList(x);
            TurtleShell.this.out.decIndent(2);
            TurtleShell.this.println();
            TurtleShell.this.print("]");
            TurtleShell.this.out.setAbsoluteIndent(indent0);
        }

        private void list(List<Node> elts) {
            if (elts.size() == 0) {
                TurtleShell.this.out.print("()");
                return;
            }
            TurtleShell.this.out.print("(");
            for (Node n : elts) {
                TurtleShell.this.out.print(" ");
                this.writeNodePretty(n);
            }
            TurtleShell.this.out.print(" )");
        }

        private boolean isPrettyNode(Node n) {
            if (this.allowDeepPretty) {
                if (this.lists.containsKey(n)) {
                    return true;
                }
                if (this.nestedObjects.contains(n)) {
                    return true;
                }
            }
            return WriterConst.RDF_Nil.equals((Object)n);
        }

        private void writeNodePretty(Node obj) {
            if (this.lists.containsKey(obj)) {
                this.list(this.lists.get(obj));
            } else if (this.nestedObjects.contains(obj)) {
                this.writeNestedObject(obj);
            } else if (WriterConst.RDF_Nil.equals((Object)obj)) {
                TurtleShell.this.out.print("()");
            } else {
                TurtleShell.this.writeNode(obj);
            }
            if (this.nestedObjects.contains(obj)) {
                this.nestedObjectsWritten.add(obj);
            }
        }

        private void write_S_P_Gap() {
            if (TurtleShell.this.out.getCol() > 20) {
                TurtleShell.this.out.println();
            } else {
                TurtleShell.this.gap(2);
            }
        }
    }
}

