/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.Vars;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.VarUtils;

public class OpVars {
    private static Set<Var> collector() {
        return new LinkedHashSet<Var>();
    }

    public static Set<Var> visibleVars(Op op) {
        Set<Var> acc = OpVars.collector();
        OpVars.visibleVars(op, acc);
        return acc;
    }

    public static void visibleVars(Op op, Set<Var> acc) {
        OpVarsPattern visitor = new OpVarsPattern(acc, true);
        OpWalker.walk(new WalkerVisitorVisible(visitor, acc), op);
    }

    public static Set<Var> fixedVars(Op op) {
        Set<Var> acc = OpVars.collector();
        OpVars.fixedVars(op, acc);
        return acc;
    }

    public static void fixedVars(Op op, Set<Var> acc) {
        OpVarsPattern visitor = new OpVarsPattern(acc, true);
        OpWalker.walk(new WalkerVisitorFixed(visitor, acc), op);
    }

    public static Tuple<Set<Var>> mentionedVarsByPosition(Op op) {
        Set<Var> graphAcc = OpVars.collector();
        Set<Var> subjAcc = OpVars.collector();
        Set<Var> predAcc = OpVars.collector();
        Set<Var> objAcc = OpVars.collector();
        Set<Var> unknownAcc = OpVars.collector();
        OpVarsPatternWithPositions visitor = new OpVarsPatternWithPositions(graphAcc, subjAcc, predAcc, objAcc, unknownAcc, false);
        OpWalker.walk(op, visitor);
        return Tuple.createTuple((Object[])new Set[]{graphAcc, subjAcc, predAcc, objAcc, unknownAcc});
    }

    public static Tuple<Set<Var>> mentionedVarsByPosition(Op ... ops) {
        Set<Var> graphAcc = OpVars.collector();
        Set<Var> subjAcc = OpVars.collector();
        Set<Var> predAcc = OpVars.collector();
        Set<Var> objAcc = OpVars.collector();
        Set<Var> unknownAcc = OpVars.collector();
        OpVarsPatternWithPositions visitor = new OpVarsPatternWithPositions(graphAcc, subjAcc, predAcc, objAcc, unknownAcc, false);
        for (Op op : ops) {
            OpWalker.walk(op, visitor);
        }
        return Tuple.createTuple((Object[])new Set[]{graphAcc, subjAcc, predAcc, objAcc, unknownAcc});
    }

    public static Collection<Var> mentionedVars(Op op) {
        Set<Var> acc = OpVars.collector();
        OpVars.mentionedVars(op, acc);
        return acc;
    }

    public static void mentionedVars(Op op, Set<Var> acc) {
        OpVarsMentioned visitor = new OpVarsMentioned(acc);
        OpWalker.walk(op, visitor);
    }

    private static class OpVarsMentioned
    extends OpVarsPattern {
        OpVarsMentioned(Set<Var> acc) {
            super(acc, false);
        }

        @Override
        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.acc);
        }

        @Override
        public void visit(OpOrder opOrder) {
            ExprVars.varsMentioned((Collection<Var>)this.acc, opOrder.getConditions());
        }
    }

    private static class OpVarsPatternWithPositions
    extends OpVisitorBase {
        protected Set<Var> graphAcc;
        protected Set<Var> subjAcc;
        protected Set<Var> predAcc;
        protected Set<Var> objAcc;
        protected Set<Var> unknownAcc;
        final boolean visibleOnly;

        OpVarsPatternWithPositions(Set<Var> graphAcc, Set<Var> subjAcc, Set<Var> predAcc, Set<Var> objAcc, Set<Var> unknownAcc, boolean visibleOnly) {
            this.graphAcc = graphAcc;
            this.subjAcc = subjAcc;
            this.predAcc = predAcc;
            this.objAcc = objAcc;
            this.unknownAcc = unknownAcc;
            this.visibleOnly = visibleOnly;
        }

        @Override
        public void visit(OpBGP opBGP) {
            this.vars(opBGP.getPattern());
        }

        @Override
        public void visit(OpPath opPath) {
            Vars.addVar(this.subjAcc, opPath.getTriplePath().getSubject());
            Vars.addVar(this.objAcc, opPath.getTriplePath().getObject());
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            Vars.addVar(this.graphAcc, quadPattern.getGraphNode());
            this.vars(quadPattern.getBasicPattern());
        }

        @Override
        public void visit(OpGraph opGraph) {
            Vars.addVar(this.graphAcc, opGraph.getNode());
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            Vars.addVar(this.graphAcc, dsNames.getGraphNode());
        }

        @Override
        public void visit(OpTable opTable) {
            Table t = opTable.getTable();
            this.unknownAcc.addAll(t.getVars());
        }

        @Override
        public void visit(OpProject opProject) {
            List<Var> vs = opProject.getVars();
            if (this.visibleOnly) {
                this.clear(this.graphAcc, vs);
                this.clear(this.subjAcc, vs);
                this.clear(this.predAcc, vs);
                this.clear(this.objAcc, vs);
            }
            for (Var v : vs) {
                if (this.graphAcc.contains((Object)v) || this.subjAcc.contains((Object)v) || this.predAcc.contains((Object)v) || this.objAcc.contains((Object)v)) continue;
                Vars.addVar(this.unknownAcc, (Node)v);
            }
        }

        @Override
        public void visit(OpAssign opAssign) {
            this.unknownAcc.addAll(opAssign.getVarExprList().getVars());
        }

        @Override
        public void visit(OpExtend opExtend) {
            this.unknownAcc.addAll(opExtend.getVarExprList().getVars());
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            this.addvars(this.subjAcc, opPropFunc.getSubjectArgs());
            this.addvars(this.objAcc, opPropFunc.getObjectArgs());
        }

        private void addvars(Set<Var> acc, PropFuncArg pfArg) {
            if (pfArg.isNode()) {
                Vars.addVar(acc, pfArg.getArg());
                return;
            }
            for (Node n : pfArg.getArgList()) {
                Vars.addVar(acc, n);
            }
        }

        @Override
        public void visit(OpProcedure opProc) {
            this.unknownAcc.addAll(OpVars.mentionedVars(opProc));
        }

        private void vars(BasicPattern bp) {
            for (Triple t : bp.getList()) {
                Vars.addVar(this.subjAcc, t.getSubject());
                Vars.addVar(this.predAcc, t.getPredicate());
                Vars.addVar(this.objAcc, t.getObject());
            }
        }

        private void clear(Set<Var> acc, List<Var> visible) {
            ArrayList<Var> toRemove = new ArrayList<Var>();
            for (Var found : acc) {
                if (visible.contains((Object)found)) continue;
                toRemove.add(found);
            }
            for (Var v : toRemove) {
                acc.remove((Object)v);
            }
        }
    }

    private static class OpVarsPattern
    extends OpVisitorBase {
        protected Set<Var> acc;
        final boolean visibleOnly;

        OpVarsPattern(Set<Var> acc, boolean visibleOnly) {
            this.acc = acc;
            this.visibleOnly = visibleOnly;
        }

        @Override
        public void visit(OpBGP opBGP) {
            VarUtils.addVars(this.acc, opBGP.getPattern());
        }

        @Override
        public void visit(OpPath opPath) {
            Vars.addVar(this.acc, opPath.getTriplePath().getSubject());
            Vars.addVar(this.acc, opPath.getTriplePath().getObject());
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            Vars.addVar(this.acc, quadPattern.getGraphNode());
            VarUtils.addVars(this.acc, quadPattern.getBasicPattern());
        }

        @Override
        public void visit(OpGraph opGraph) {
            Vars.addVar(this.acc, opGraph.getNode());
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            Vars.addVar(this.acc, dsNames.getGraphNode());
        }

        @Override
        public void visit(OpTable opTable) {
            Table t = opTable.getTable();
            this.acc.addAll(t.getVars());
        }

        @Override
        public void visit(OpProject opProject) {
            if (this.visibleOnly) {
                this.acc.clear();
            }
            this.acc.addAll(opProject.getVars());
        }

        @Override
        public void visit(OpAssign opAssign) {
            this.acc.addAll(opAssign.getVarExprList().getVars());
        }

        @Override
        public void visit(OpExtend opExtend) {
            this.acc.addAll(opExtend.getVarExprList().getVars());
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            this.addvars(opPropFunc.getSubjectArgs());
            this.addvars(opPropFunc.getObjectArgs());
        }

        private void addvars(PropFuncArg pfArg) {
            if (pfArg.isNode()) {
                Vars.addVar(this.acc, pfArg.getArg());
                return;
            }
            for (Node n : pfArg.getArgList()) {
                Vars.addVar(this.acc, n);
            }
        }

        @Override
        public void visit(OpProcedure opProc) {
            opProc.getArgs().varsMentioned(this.acc);
        }
    }

    private static class WalkerVisitorFixed
    extends OpWalker.WalkerVisitor {
        private final Collection<Var> acc;

        public WalkerVisitorFixed(OpVarsPattern visitor, Collection<Var> acc) {
            super(visitor);
            this.acc = acc;
        }

        @Override
        public void visit(OpLeftJoin x) {
            x.getLeft().visit(this);
        }

        @Override
        public void visit(OpConditional x) {
            x.getLeft().visit(this);
        }

        @Override
        public void visit(OpUnion x) {
            Set<Var> left = OpVars.fixedVars(x.getLeft());
            Set<Var> right = OpVars.fixedVars(x.getRight());
            Set r = SetUtils.intersection(left, right);
            this.acc.addAll(r);
        }

        @Override
        public void visit(OpProject op) {
            this.before(op);
            this.acc.addAll(op.getVars());
            this.after(op);
        }

        @Override
        public void visit(OpMinus op) {
            this.before(op);
            if (op.getLeft() != null) {
                op.getLeft().visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }

    private static class WalkerVisitorVisible
    extends OpWalker.WalkerVisitor {
        private final Collection<Var> acc;

        public WalkerVisitorVisible(OpVarsPattern visitor, Collection<Var> acc) {
            super(visitor);
            this.acc = acc;
        }

        @Override
        public void visit(OpProject op) {
            this.before(op);
            this.acc.addAll(op.getVars());
            this.after(op);
        }

        @Override
        public void visit(OpMinus op) {
            this.before(op);
            if (op.getLeft() != null) {
                op.getLeft().visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }
}

