/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.PropertyFunctionGenerator;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;

public class TransformPropertyFunction
extends TransformCopy {
    private final Context context;
    private final boolean doingMagicProperties;
    private final PropertyFunctionRegistry registry;

    public TransformPropertyFunction(Context context) {
        this.context = context;
        this.doingMagicProperties = context.isTrue(ARQ.enablePropertyFunctions);
        this.registry = PropertyFunctionRegistry.chooseRegistry(context);
    }

    @Override
    public Op transform(OpTriple opTriple) {
        if (!this.doingMagicProperties) {
            return opTriple;
        }
        Op x = this.transform(opTriple.asBGP());
        if (!(x instanceof OpBGP)) {
            return x;
        }
        if (opTriple.equivalent((OpBGP)x)) {
            return opTriple;
        }
        return x;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        if (!this.doingMagicProperties) {
            return opBGP;
        }
        return PropertyFunctionGenerator.buildPropertyFunctions(this.registry, opBGP, this.context);
    }
}

