/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.writers.WriterGraph;
import org.apache.jena.sparql.util.Context;

public abstract class DatasetGraphBase
implements DatasetGraph {
    private final Lock lock = new LockMRSW();
    private Context context = new Context();
    private static final int DeleteBufferSize = 1000;

    protected DatasetGraphBase() {
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.contains(graphNode, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public abstract Graph getDefaultGraph();

    @Override
    public abstract Graph getGraph(Node var1);

    @Override
    public abstract void addGraph(Node var1, Graph var2);

    @Override
    public abstract void removeGraph(Node var1);

    @Override
    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("DatasetGraph.setDefaultGraph");
    }

    @Override
    public void add(Quad quad) {
        throw new UnsupportedOperationException("DatasetGraph.add(Quad)");
    }

    @Override
    public void delete(Quad quad) {
        throw new UnsupportedOperationException("DatasetGraph.delete(Quad)");
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.add(new Quad(g, s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(new Quad(g, s, p, o));
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        int len;
        Quad[] buffer = new Quad[1000];
        do {
            Iterator<Quad> iter = this.find(g, s, p, o);
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                buffer[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                this.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (len >= 1000);
    }

    @Override
    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        if (quad == null) {
            return this.find();
        }
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        boolean b = iter.hasNext();
        Iter.close(iter);
        return b;
    }

    protected static boolean isWildcard(Node g) {
        return g == null || g == Node.ANY;
    }

    @Override
    public void clear() {
        this.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public boolean isEmpty() {
        return !this.contains(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void close() {
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        WriterGraph.output((IndentedWriter)out, this, null);
        return out.asString();
    }

    protected static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return DatasetGraphBase.triples2quads(Quad.defaultGraphIRI, iter);
    }

    protected static Iter<Quad> triples2quads(Node graphNode, Iterator<Triple> iter) {
        return Iter.iter(iter).map(t -> new Quad(graphNode, (Triple)t));
    }
}

