/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMonitor;
import org.apache.jena.sparql.core.DatasetGraphTrackActive;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphWithLock
extends DatasetGraphTrackActive
implements Sync {
    private final ThreadLocalReadWrite readWrite = new ThreadLocalReadWrite();
    private final ThreadLocalBoolean inTransaction = new ThreadLocalBoolean();
    private final DatasetGraph dsg;
    private final DatasetChanges dsChanges;

    public DatasetGraphWithLock(DatasetGraph dsg) {
        this.dsg = dsg;
        this.dsChanges = DatasetGraphWithLock.findDatasetChanges(dsg);
    }

    private static DatasetChanges findDatasetChanges(DatasetGraph dataset) {
        while (!(dataset instanceof DatasetGraphMonitor)) {
            if (!(dataset instanceof DatasetGraphWrapper)) {
                return null;
            }
            dataset = ((DatasetGraphWrapper)dataset).getWrapped();
        }
        return ((DatasetGraphMonitor)dataset).getMonitor();
    }

    @Override
    protected DatasetGraph get() {
        return this.dsg;
    }

    @Override
    protected void checkActive() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction");
        }
    }

    @Override
    protected void checkNotActive() {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction");
        }
    }

    @Override
    public boolean isInTransaction() {
        return (Boolean)this.inTransaction.get();
    }

    protected boolean isTransactionType(ReadWrite readWriteType) {
        return this.readWrite.get() == readWriteType;
    }

    @Override
    protected void _begin(ReadWrite readWrite) {
        this.readWrite.set(readWrite);
        boolean b = this.isTransactionType(ReadWrite.READ);
        this.get().getLock().enterCriticalSection(b);
        this.inTransaction.set(true);
        if (this.dsChanges != null) {
            this.dsChanges.start();
        }
    }

    @Override
    protected void _commit() {
        if (this.isTransactionType(ReadWrite.WRITE)) {
            this.sync();
        }
        this._end();
    }

    @Override
    protected void _abort() {
        if (this.isTransactionType(ReadWrite.WRITE) && !this.abortImplemented()) {
            this._end();
            throw new JenaTransactionException("Can't abort a write lock-transaction");
        }
        this._end();
    }

    protected boolean abortImplemented() {
        return false;
    }

    @Override
    protected void _end() {
        if (this.isInTransaction()) {
            if (this.dsChanges != null) {
                this.dsChanges.finish();
            }
            this.clearState();
            this.get().getLock().leaveCriticalSection();
        }
    }

    @Override
    protected void _close() {
        if (this.get() != null) {
            this.get().close();
        }
    }

    private void clearState() {
        this.inTransaction.set(false);
        this.readWrite.set(null);
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    public void sync() {
        SystemARQ.sync(this.get());
    }

    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception ex) {
            return Lib.className((Object)this);
        }
    }

    static class ThreadLocalReadWrite
    extends ThreadLocal<ReadWrite> {
        ThreadLocalReadWrite() {
        }

        @Override
        protected ReadWrite initialValue() {
            return null;
        }
    }

    static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        ThreadLocalBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

