/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphWrapper
implements DatasetGraph,
Sync {
    private final DatasetGraph dsg;

    public final DatasetGraph getWrapped() {
        return this.get();
    }

    public final DatasetGraph getBase() {
        DatasetGraph dsgw = this.dsg;
        while (dsgw instanceof DatasetGraphWrapper) {
            dsgw = ((DatasetGraphWrapper)this.dsg).getWrapped();
        }
        return dsgw;
    }

    protected DatasetGraph get() {
        return this.dsg;
    }

    public DatasetGraphWrapper(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.get().containsGraph(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.get().getDefaultGraph();
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.get().getGraph(graphNode);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.get().addGraph(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.get().removeGraph(graphName);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.get().setDefaultGraph(g);
    }

    @Override
    public Lock getLock() {
        return this.get().getLock();
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.get().listGraphNodes();
    }

    @Override
    public void add(Quad quad) {
        this.get().add(quad);
    }

    @Override
    public void delete(Quad quad) {
        this.get().delete(quad);
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.get().add(g, s, p, o);
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.get().delete(g, s, p, o);
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        this.get().deleteAny(g, s, p, o);
    }

    @Override
    public void clear() {
        this.get().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.get().isEmpty();
    }

    @Override
    public Iterator<Quad> find() {
        return this.get().find();
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.get().find(quad);
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.get().find(g, s, p, o);
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return this.get().findNG(g, s, p, o);
    }

    @Override
    public boolean contains(Quad quad) {
        return this.get().contains(quad);
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.get().contains(g, s, p, o);
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    @Override
    public long size() {
        return this.get().size();
    }

    @Override
    public void close() {
        this.get().close();
    }

    public String toString() {
        return this.get().toString();
    }

    public void sync() {
        SystemARQ.sync(this.get());
    }
}

