/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.journaling;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.ext.com.google.common.collect.Lists;
import org.apache.jena.sparql.core.journaling.Operation;
import org.apache.jena.sparql.core.journaling.ReversibleOperationRecord;

public class ListBackedOperationRecord<OpType extends Operation.InvertibleOperation<?, ?, ?, ?>>
implements ReversibleOperationRecord<OpType> {
    private final List<OpType> operations;

    public ListBackedOperationRecord(List<OpType> ops) {
        this.operations = ops;
    }

    @Override
    public void accept(OpType op) {
        this.operations.add(op);
    }

    @Override
    public ListBackedOperationRecord<OpType> reverse() {
        return new ListBackedOperationRecord<OpType>(Lists.reverse(this.operations));
    }

    @Override
    public void consume(Consumer<OpType> consumer) {
        Iterator<OpType> i = this.operations.iterator();
        while (i.hasNext()) {
            consumer.accept(i.next());
            i.remove();
        }
    }

    @Override
    public void clear() {
        this.operations.clear();
    }
}

