/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.mem.PMapTripleTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.sparql.core.mem.TupleSlot;

public enum TripleTableForm implements Supplier<TripleTable>,
Predicate<Set<TupleSlot>>
{
    SPO(EnumSet.of(TupleSlot.SUBJECT, TupleSlot.PREDICATE), TupleSlot.SUBJECT){

        @Override
        public TripleTable get() {
            return new PMapTripleTable(this.name()){

                @Override
                protected Triple triple(Node s, Node p, Node o) {
                    return Triple.create((Node)s, (Node)p, (Node)o);
                }

                @Override
                public Stream<Triple> find(Node s, Node p, Node o) {
                    return this._find(s, p, o);
                }

                @Override
                public void add(Triple t) {
                    this._add(t.getSubject(), t.getPredicate(), t.getObject());
                }

                @Override
                public void delete(Triple t) {
                    this._delete(t.getSubject(), t.getPredicate(), t.getObject());
                }
            };
        }
    }
    ,
    POS(EnumSet.of(TupleSlot.PREDICATE, TupleSlot.OBJECT), TupleSlot.PREDICATE){

        @Override
        public TripleTable get() {
            return new PMapTripleTable(this.name()){

                @Override
                protected Triple triple(Node p, Node o, Node s) {
                    return Triple.create((Node)s, (Node)p, (Node)o);
                }

                @Override
                public Stream<Triple> find(Node s, Node p, Node o) {
                    return this._find(p, o, s);
                }

                @Override
                public void add(Triple t) {
                    this._add(t.getPredicate(), t.getObject(), t.getSubject());
                }

                @Override
                public void delete(Triple t) {
                    this._delete(t.getPredicate(), t.getObject(), t.getSubject());
                }
            };
        }
    }
    ,
    OSP(EnumSet.of(TupleSlot.OBJECT, TupleSlot.SUBJECT), TupleSlot.OBJECT){

        @Override
        public TripleTable get() {
            return new PMapTripleTable(this.name()){

                @Override
                protected Triple triple(Node o, Node s, Node p) {
                    return Triple.create((Node)s, (Node)p, (Node)o);
                }

                @Override
                public Stream<Triple> find(Node s, Node p, Node o) {
                    return this._find(o, s, p);
                }

                @Override
                public void add(Triple t) {
                    this._add(t.getObject(), t.getSubject(), t.getPredicate());
                }

                @Override
                public void delete(Triple t) {
                    this._delete(t.getObject(), t.getSubject(), t.getPredicate());
                }
            };
        }
    };

    public final Set<TupleSlot> twoPrefix;
    public final Set<TupleSlot> onePrefix;

    private TripleTableForm(Set<TupleSlot> tp, TupleSlot op) {
        this.twoPrefix = tp;
        this.onePrefix = EnumSet.of(op);
    }

    @Override
    public boolean test(Set<TupleSlot> pattern) {
        return this.twoPrefix.equals(pattern) || this.onePrefix.equals(pattern) || pattern.size() == 3;
    }

    public static TripleTableForm chooseFrom(Set<TupleSlot> pattern) {
        return TripleTableForm.tableForms().filter(f -> f.test(pattern)).findFirst().orElse(SPO);
    }

    public static Stream<TripleTableForm> tableForms() {
        return Arrays.stream(TripleTableForm.values());
    }
}

