/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.index.IndexTable;

public class HashIndexTable
implements IndexTable {
    private final Set<Key> table;
    private Map<Var, Integer> varColumns;
    private boolean missingValue;

    public HashIndexTable(Set<Var> commonVars, QueryIterator data) throws MissingBindingException {
        this.initColumnMappings(commonVars);
        if (commonVars.size() == 0) {
            this.table = null;
            return;
        }
        this.table = new HashSet<Key>();
        this.missingValue = false;
        while (data.hasNext()) {
            Binding binding = data.nextBinding();
            this.addBindingToTable(binding);
        }
        data.close();
    }

    @Override
    public boolean containsCompatibleWithSharedDomain(Binding binding) {
        if (this.table == null) {
            return false;
        }
        Key indexKey = this.convertToKey(binding);
        if (this.table.contains(indexKey)) {
            return true;
        }
        if (this.anyUnbound(indexKey)) {
            return this.exhaustiveSearch(indexKey);
        }
        return false;
    }

    private boolean anyUnbound(Key mappedBinding) {
        for (Node n : mappedBinding.getNodes()) {
            if (n != null) continue;
            return true;
        }
        return false;
    }

    private void initColumnMappings(Set<Var> commonVars) {
        this.varColumns = new HashMap<Var, Integer>();
        int c = 0;
        for (Var var : commonVars) {
            this.varColumns.put(var, c++);
        }
    }

    private void addBindingToTable(Binding binding) throws MissingBindingException {
        Key key = this.convertToKey(binding);
        this.table.add(key);
        if (this.missingValue) {
            throw new MissingBindingException(this.table, this.varColumns);
        }
    }

    private Key convertToKey(Binding binding) {
        Node[] indexKey = new Node[this.varColumns.size()];
        for (Map.Entry<Var, Integer> varCol : this.varColumns.entrySet()) {
            Node value = binding.get(varCol.getKey());
            if (value == null) {
                this.missingValue = true;
            }
            indexKey[varCol.getValue().intValue()] = value;
        }
        return new Key(indexKey);
    }

    private boolean exhaustiveSearch(Key mappedBindingLeft) {
        for (Key mappedBindingRight : this.table) {
            if (!mappedBindingLeft.compatibleAndSharedDomain(mappedBindingRight)) continue;
            return true;
        }
        return false;
    }

    static class Key {
        final Node[] nodes;

        Key(Node[] nodes) {
            this.nodes = nodes;
        }

        public Node[] getNodes() {
            return this.nodes;
        }

        public String toString() {
            return Arrays.asList(this.nodes).toString();
        }

        public int hashCode() {
            int result = 0;
            for (Node n : this.nodes) {
                result ^= n == null ? 0 : n.hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Node[] other = ((Key)o).nodes;
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!(this.nodes[i] == null ? other[i] != null : !this.nodes[i].equals((Object)other[i]))) continue;
                return false;
            }
            return true;
        }

        public boolean compatibleAndSharedDomain(Key mappedBindingR) {
            Node[] nodesRight = mappedBindingR.getNodes();
            boolean sharedDomain = false;
            for (int c = 0; c < this.nodes.length; ++c) {
                Node nLeft = this.nodes[c];
                Node nRight = nodesRight[c];
                if (nLeft == null || nRight == null) continue;
                if (nLeft.equals((Object)nRight)) {
                    return false;
                }
                sharedDomain = true;
            }
            return sharedDomain;
        }
    }

    static class MissingBindingException
    extends Exception {
        private final Set<Key> data;
        private final Map<Var, Integer> varMappings;

        public MissingBindingException(Set<Key> data, Map<Var, Integer> varMappings) {
            this.data = data;
            this.varMappings = varMappings;
        }

        public Set<Key> getData() {
            return this.data;
        }

        public Map<Var, Integer> getMap() {
            return this.varMappings;
        }
    }
}

