/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class NodeConst {
    public static final Node nodeTrue = NodeConst.literal("true", (RDFDatatype)XSDDatatype.XSDboolean);
    public static final Node nodeFalse = NodeConst.literal("false", (RDFDatatype)XSDDatatype.XSDboolean);
    public static final Node nodeZero = NodeConst.literal("0", (RDFDatatype)XSDDatatype.XSDinteger);
    public static final Node nodeOne = NodeConst.literal("1", (RDFDatatype)XSDDatatype.XSDinteger);
    public static final Node nodeTwo = NodeConst.literal("2", (RDFDatatype)XSDDatatype.XSDinteger);
    public static final Node nodeMinusOne = NodeConst.literal("-1", (RDFDatatype)XSDDatatype.XSDinteger);
    public static final Node emptyString = NodeFactory.createLiteral((String)"");
    public static final Node nodeRDFType = RDF.Nodes.type;
    public static final Node nodeFirst = RDF.Nodes.first;
    public static final Node nodeRest = RDF.Nodes.rest;
    public static final Node nodeNil = RDF.Nodes.nil;
    public static final Node nodeANY = Node.ANY;
    public static final Node nodeOwlSameAs = OWL.sameAs.asNode();
    public static final Node rdfLangString = RDF.Nodes.langString;
    public static final RDFDatatype dtLangString = RDF.dtLangString;

    private static Node literal(String lex, RDFDatatype dt) {
        return NodeFactory.createLiteral((String)lex, (RDFDatatype)dt);
    }

    private static Node uri(String uriStr) {
        return NodeFactory.createURI((String)uriStr);
    }
}

