/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorResourceClosing;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.util.iterator.ClosableIterator;

public class ModelUtils {
    public static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isVariable()) {
            throw new QueryException("Variable: " + n);
        }
        if (model != null) {
            return model.asRDFNode(n);
        }
        if (n.isLiteral()) {
            return new LiteralImpl(n, null);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, null);
        }
        throw new ARQInternalErrorException("Unknown node type for node: " + n);
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node oNode;
        Node pNode;
        if (model == null) {
            throw new ARQInternalErrorException("Attempt to create statement with null model");
        }
        Node sNode = t.getSubject();
        if (!ModelUtils.isValidAsStatement(sNode, pNode = t.getPredicate(), oNode = t.getObject())) {
            return null;
        }
        return model.asStatement(t);
    }

    public static boolean isValidAsStatement(Node s, Node p, Node o) {
        if (s.isLiteral() || s.isVariable()) {
            return false;
        }
        if (!p.isURI()) {
            return false;
        }
        return !o.isVariable();
    }

    public static StmtIterator triplesToStatements(final Iterator<Triple> it, Model refModel) {
        return new StmtIteratorImpl(Iter.map(it, arg_0 -> ((Model)refModel).asStatement(arg_0))){

            public void close() {
                if (it instanceof ClosableIterator) {
                    ((ClosableIterator)it).close();
                } else {
                    Iter.close((Iterator)it);
                }
            }
        };
    }

    public static Iterator<Triple> statementsToTriples(final Iterator<Statement> it) {
        return new IteratorResourceClosing(Iter.map(it, FrontsTriple::asTriple), new Closeable(){

            public void close() {
                if (it instanceof ClosableIterator) {
                    ((ClosableIterator)it).close();
                } else {
                    Iter.close((Iterator)it);
                }
            }
        });
    }
}

