package rs.ac.bg.fon.ai.inteligentniSistemi.sparql;

import java.util.List;

import org.apache.jena.rdf.model.Model;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.persistence.RDFModel;
import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.persistence.RDFModelTDB;
import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.services.MovieService;

public class MainTDB {

	public static void main(String[] args) {

		// call only once to load data from files into TDB store
//		RDFModelTDB.getInstance().loadDataFromFiles("data");

		Model graph = RDFModelTDB.getInstance().getGraph();
		
		MovieService movieService = new MovieService(graph);
		
		// QUERY 1: Get all classes
//		List<String> allClasses = movieService.getAllClasses();
//		
//		for (String clazz : allClasses) {
//			System.out.println(clazz);
//		}
		
		
		// QUERY 2: Get all instances of class Person
//		List<String> persons = movieService.getAllPersons();
//		
//		for (String person : persons) {
//			System.out.println(person);
//		}
		
		
		// QUERY 3: Describe a person
//		Model personGraph = movieService.describeResource("http://www.imdb.com/name/nm0634240/");
//		personGraph.write(System.out, "JSON-LD");
		
		
		// QUERY 4: Get all instances of class Movie
//		List<String> movies = movieService.getAllMovies();
//		
//		for (String movie : movies) {
//			System.out.println(movie);
//		}
		
		
		// QUERY 5: Describe a movie
//		Model movieGraph = movieService.describeResource("http://www.imdb.com/title/tt2488496/");
//		movieGraph.write(System.out, "JSON-LD");
		
		
		// QUERY 6: Get all person names
//		List<String> movies = movieService.getAllPersonNames();
//
//		for (String movie : movies) {
//			System.out.println(movie);
//		}
		
		
		// QUERY 7: Titles of all movies released in 2010 and after
//		List<String> movies = movieService.getAllMoviesNewerThan2010();
//
//		for (String movie : movies) {
//			System.out.println(movie);
//		}

		
		// QUERY 9: Titles of all movies released directed by J. J. Abrams
//		List<String> movies1 = movieService.getAllMoviesByJJAbrams();
//
//		for (String movie : movies1) {
//			System.out.println(movie);
//		}
		
		// must be called after finished working with TDB store
		RDFModelTDB.getInstance().closeDataModel();
	}
}
