package rs.ac.bg.fon.ai.inteligentniSistemi.sparql.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Date;

import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.util.FileManager;

import rs.ac.bg.fon.ai.inteligentniSistemi.sparql.util.Constants;

public class RDFModelTDB {

	private static final String directory = "tdb";
	private Dataset dataset;

	private static RDFModelTDB INSTANCE;
	
	private RDFModelTDB() { 
		dataset = TDBFactory.createDataset(directory);
		getGraph().setNsPrefix("Person", Constants.SCHEMA + "Person");
		getGraph().setNsPrefix("Movie", Constants.SCHEMA + "Movie");
		getGraph().setNsPrefix("name", Constants.SCHEMA + "name");
		getGraph().setNsPrefix("description", Constants.SCHEMA + "description");
		getGraph().setNsPrefix("actors", Constants.SCHEMA + "actors");
		getGraph().setNsPrefix("datePublished", Constants.SCHEMA + "datePublished");
		getGraph().setNsPrefix("director", Constants.SCHEMA + "director");
		getGraph().setNsPrefix("duration", Constants.SCHEMA + "duration");
		getGraph().setNsPrefix("genre", Constants.SCHEMA + "genre");
		getGraph().setNsPrefix("keywords", Constants.SCHEMA + "keywords");
	}

	public static RDFModelTDB getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new RDFModelTDB();
		}
		return INSTANCE;
	}

	public Model getGraph() {
		return dataset.getDefaultModel();
	}
	
	public void loadDataFromFiles(String folderPath) {
		System.out.println("Importing data - " + new Date());
		
		File folder = new File(folderPath);
		File[] listOfFiles = folder.listFiles();

		for (int i = 0; i < listOfFiles.length; i++) {
			if (listOfFiles[i].isFile()) {
				try {
					FileReader in = new FileReader(listOfFiles[i]);
					dataset.getDefaultModel().read(in, "", "JSON-LD");
				} catch (FileNotFoundException e) {
					System.out.println(e);
				}
			}
		}
		
		System.out.println("Import finished - " + new Date());
	}

	public void closeDataModel() {
		dataset.close();
	}

}
