package rs.ac.bg.fon.ai.sparqllab;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class Main {
	
	public static final String dataSource = "data/ldodds-knows.json"; 
	public static final String baseURI = "http://www.ldodds.com#"; 

	public static void main(String[] args) {
		
		Model rdfGraph = readModelFromFile(dataSource, baseURI);
		
		// print the rdf graph
//		rdfGraph.write(System.out, "TURTLE", baseURI);
		
		try {
		
			// read query from file
			String task = "Task1";
			String queryString = SPARQLUtil.readTextFromFile("queries/" + task + ".txt", "UTF-8");	
			
			// execute SELECT query
			ResultSetRewindable results = 
					SPARQLUtil.executeSelectQueryOverModel(queryString, rdfGraph);
//					SPARQLUtil.executeSelectQueryOverSparqlEndpoint(queryString, 
//							SPARQLUtil.DBPEDIA_SPARQL_ENDPOINT);
			// print the results
			SPARQLUtil.printSPARQLSelectResults(results, System.out);
			// rewind the results set so that it can be used again
			results.reset();
			// print the number of results
			System.out.println( "\n\nTotal number of results: " + SPARQLUtil.getResultsCount(results) );
			results.reset();
			// write the results to a JSON file
			SPARQLUtil.serializeResultsToFile("results/" + task + ".json", results, "JSON");
		
			// execute ASK query
//			boolean askResult = SPARQLUtil.executeAskSparqlQuery(queryString, SPARQLUtil.DBPEDIA_SPARQL_ENDPOINT);
//			System.out.println("ask result: " + askResult);
			
			// execute DESCRIBE query
//			Model descResult = SPARQLUtil.executeDescribeSparqlQuery(queryString, SPARQLUtil.DBPEDIA_SPARQL_ENDPOINT);
//			SPARQLUtil.serializeResultsToFile("results/" + task + ".json", descResult, "TURTLE");
			
			// execute CONSTRUCT query
//			Model constructResult = SPARQLUtil.executeConstructSparqlQuery(queryString, SPARQLUtil.DBPEDIA_SPARQL_ENDPOINT);
//			SPARQLUtil.serializeResultsToFile("results/" + task + ".json", constructResult, "TURTLE");
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	private static Model readModelFromFile(String fileName, String baseURI) {
		
		Model rdfDataModel = ModelFactory.createDefaultModel();
		
		try {
			FileInputStream in = new FileInputStream(fileName);
			rdfDataModel.read(in, baseURI, "JSON-LD");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		
		return rdfDataModel;
		
	}

}
