/*
 * Authors: 
 * Uros Krcadinac - uros@krcadinac.com
 * Nikola Milikic - nikola.milikic@gmail.com
 * 
 * GOOD OLD AI Research Lab - http://goodoldai.org
 * Intelligent Systems (FON, University of Belgrade) - http://is.fon.rs/
 * 
 * November, 2013.
 * 
 * This code is partially based on these very useful resources for text mining in Weka:
 * http://jmgomezhidalgo.blogspot.com.es/2013/04/a-simple-text-classifier-in-java-with.html
 * http://jmgomezhidalgo.blogspot.com.es/2013/05/language-identification-as-text.html
 * http://jmgomezhidalgo.blogspot.com.es/2013/06/baseline-sentiment-analysis-with-weka.html
 * 
 * (Note: if you plane to use the code from these sites, please use Weka 3.7. 
 * Our code is using Weka 3.6. There are some differences in terms of API.) 
 * 
 */

package rs.fon.is.weka.textmining.li;

public class StartLanguageIdentification {

	public static void main (String[] args) {
		
		/*
		 * Examples of text in 3 different languages.
		 */
		String textEn = "This is a sample test for the language identifier demo.";
		String textFr = "Ceci est un test de l'�chantillon pour la d�monstration de l'identificateur de langue.";
		String textEs = "Esto es un texto de prueba para la demostraci�n del identificador de idioma.";
		String newText = "At DataCamp, our students often ask us whether they should use R and/or Python for their day-to-day data analysis tasks";

		/*
		 * Paths to the classifier file and the ARFF training data file
		 */
		String classifierPath = "classifiers/languageIdentificationClassifier.dat";
		String arffFileName = "data/li/LanguageIdentificationTrainingData.arff";
		
		try {
			/*
			 * Creating a new instance of the LanguageIdentification class.
			 */
			LanguageIndentification iden = new LanguageIndentification(classifierPath, arffFileName);
			
			/*
			 * Classifying these three sentences.
			 */
			System.out.println("Classifying sentence: \"" + newText + "\"");
			iden.checkTextInstace(newText);
			
			System.out.println("Classifying sentence: \"" + textFr + "\"");
			iden.checkTextInstace(textFr);
			
			System.out.println("Classifying sentence: \"" + textEs + "\"");
			iden.checkTextInstace(textEs);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
