/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.core.WekaException;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.JSONFlowLoader;

public class TemplateManager {
    public int numTemplates() {
        return this.numBuiltinTemplates() + this.numPluginTemplates();
    }

    public int numBuiltinTemplates() {
        return PluginManager.numResourcesForWithGroupID("weka.knowledgeflow.templates");
    }

    public int numPluginTemplates() {
        return PluginManager.numResourcesForWithGroupID("weka.knowledgeflow.plugin.templates");
    }

    public List<String> getBuiltinTemplateDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> builtin = PluginManager.getResourcesWithGroupID("weka.knowledgeflow.templates");
        if (builtin != null) {
            for (String desc : builtin.keySet()) {
                result.add(desc);
            }
        }
        return result;
    }

    public List<String> getPluginTemplateDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> plugin = PluginManager.getResourcesWithGroupID("weka.knowledgeflow.plugin.templates");
        if (plugin != null) {
            for (String desc : plugin.keySet()) {
                result.add(desc);
            }
        }
        return result;
    }

    public Flow getTemplateFlow(String flowDescription) throws WekaException {
        Flow result = null;
        try {
            result = this.getBuiltinTemplateFlow(flowDescription);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = this.getPluginTemplateFlow(flowDescription);
            }
            catch (IOException ex) {
                throw new WekaException("The template flow '" + flowDescription + "' " + "does not seem to exist as a builtin or plugin template");
            }
        }
        return result;
    }

    public Flow getBuiltinTemplateFlow(String flowDescription) throws IOException, WekaException {
        InputStream flowStream = PluginManager.getPluginResourceAsStream("weka.knowledgeflow.templates", flowDescription);
        JSONFlowLoader loader = new JSONFlowLoader();
        return loader.readFlow(flowStream);
    }

    public Flow getPluginTemplateFlow(String flowDescription) throws IOException, WekaException {
        InputStream flowStream = PluginManager.getPluginResourceAsStream("weka.knowledgeflow.plugin.templates", flowDescription);
        JSONFlowLoader loader = new JSONFlowLoader();
        return loader.readFlow(flowStream);
    }

    static {
        try {
            Properties templateProps = Utils.readProperties("weka/gui/knowledgeflow/templates/templates.props");
            PluginManager.addFromProperties(templateProps, true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
            ex.printStackTrace();
        }
    }
}

