package rs.ac.bg.fon.ai.dataPreparation;

import java.text.DecimalFormat;
import java.util.Random;

import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;

public class CrossValidationExample {
	
	private static String fileName = "data/diabetes.arff";

	public static void main(String[] args) throws Exception {
		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();		// contains the full dataset we want to create train/test sets from
		data.setClassIndex(data.numAttributes() - 1);
		
		int seed = 1;			// the seed for randomizing the data
		int folds = 10;			// the number of folds to generate, >=2
		 
		
		Random rand = new Random(seed);   			// create seeded number generator
		Instances randData = new Instances(data);   // create copy of original data
		randData.randomize(rand);         			// randomize data with number generator
		
		
		// in case data has a nominal class and want perform stratified cross-validation:
		if (randData.classAttribute().isNominal())
			randData.stratify(folds);
		
		double accuracySum = 0;
	
		for (int n = 0; n < folds; n++) {
			Instances train = randData.trainCV(folds, n);
			Instances test = randData.testCV(folds, n);
			
			J48 dTreeClasf = new J48();
			dTreeClasf.buildClassifier(train);
			
			// evaluate the model with the test data
			Evaluation eval = new Evaluation(test);
			eval.evaluateModel(dTreeClasf, test);
			
			// printing the accuracy
			accuracySum += eval.pctCorrect();
		}
		
		System.out.println("Accuracy is: " + accuracySum / folds);
	}
}
