package rs.ac.bg.fon.ai.dataPreparation;

import java.util.Enumeration;

import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class DiscretizeExample {

	private static String fileName = "data/weather.numeric.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating a filter for discretization
		Discretize discretizeFilter = new Discretize();
		discretizeFilter.setAttributeIndices("first-last");
		discretizeFilter.setInputFormat(data);
		discretizeFilter.setBins(10);
		discretizeFilter.setUseEqualFrequency(false);
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, discretizeFilter);
		
		Attribute attributeSepalLength = outputTrain.attribute(1);
		
		Enumeration<Object> attributeSepalLengthEnumerator = attributeSepalLength.enumerateValues();
		
		while (attributeSepalLengthEnumerator.hasMoreElements()) {
			String attributeVal = (String) attributeSepalLengthEnumerator.nextElement();
			
			System.out.println(attributeVal);
		}

		//		System.out.println(outputTrain);
	}
}
