package rs.ac.bg.fon.ai.dataPreparation;

import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.Standardize;

public class RemoveAndStandardizeExample {

	private static String fileName = "data/weather.numeric.arff";

	public static void main(String[] args) throws Exception {

		// reading dataset from file
		DataSource loader = new DataSource(fileName);
		Instances data = loader.getDataSet();
		data.setClassIndex(data.numAttributes() - 1);
		
		// creating Remove filter in order to exclude one (or more) attributes
		Remove removeFilter = new Remove();
		removeFilter.setAttributeIndices("5");		// removes attribute with index 1
		removeFilter.setInputFormat(data);
		
		// creating a filter for standardization
		Standardize standardizeFilter = new Standardize();
		standardizeFilter.setInputFormat(data);
		
		// creating a multifilter in order to chain filter execution
		MultiFilter multiFilter = new MultiFilter();
		multiFilter.setInputFormat(data);
		multiFilter.setFilters(new Filter[]{removeFilter, standardizeFilter});
		
		// applying the filter and getting new instance set as a result
		Instances outputTrain = Filter.useFilter(data, multiFilter);
		
		System.out.println(outputTrain);
	}
}
